/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_EIP;
import ca.uhn.hl7v2.model.v22.datatype.CM_FILLER;
import ca.uhn.hl7v2.model.v22.datatype.CM_MOC;
import ca.uhn.hl7v2.model.v22.datatype.CM_NDL;
import ca.uhn.hl7v2.model.v22.datatype.CM_PARENT_RESULT;
import ca.uhn.hl7v2.model.v22.datatype.CM_PLACER;
import ca.uhn.hl7v2.model.v22.datatype.CM_SPS;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.CQ_QUANTITY;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TQ;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Observation Request");
            this.add(CM_PLACER.class, false, 1, 75, new Object[]{this.getMessage()}, "Placer Order Number");
            this.add(CM_FILLER.class, false, 1, 75, new Object[]{this.getMessage()}, "Filler Order Number");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Universal Service ID");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Priority (not used)");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Requested date / time (not used)");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation date / time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Observation end date / time");
            this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{this.getMessage()}, "Collection Volume");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage()}, "Collector Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(65)}, "Specimen action code");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Danger Code");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "Relevant clinical information");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Specimen received date / time");
            this.add(CM_SPS.class, false, 1, 300, new Object[]{this.getMessage()}, "Specimen source");
            this.add(CN.class, false, 1, 80, new Object[]{this.getMessage()}, "Ordering Provider");
            this.add(TN.class, false, 2, 40, new Object[]{this.getMessage()}, "Order Callback Phone Number");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer field 1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Placer field 2");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Filler Field 2");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Results report / status change - date / time");
            this.add(CM_MOC.class, false, 1, 40, new Object[]{this.getMessage()}, "Charge to Practice");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(74)}, "Diagnostic service section ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(123)}, "Result Status");
            this.add(CM_PARENT_RESULT.class, false, 1, 200, new Object[]{this.getMessage()}, "Parent Result");
            this.add(TQ.class, false, 0, 200, new Object[]{this.getMessage()}, "Quantity / timing");
            this.add(CN.class, false, 5, 150, new Object[]{this.getMessage()}, "Result Copies To");
            this.add(CM_EIP.class, false, 1, 150, new Object[]{this.getMessage()}, "Parent Number");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(124)}, "Transportation Mode");
            this.add(CE.class, false, 0, 300, new Object[]{this.getMessage()}, "Reason for Study");
            this.add(CM_NDL.class, false, 1, 60, new Object[]{this.getMessage()}, "Principal Result Interpreter");
            this.add(CM_NDL.class, false, 0, 60, new Object[]{this.getMessage()}, "Assistant Result Interpreter");
            this.add(CM_NDL.class, false, 0, 60, new Object[]{this.getMessage()}, "Technician");
            this.add(CM_NDL.class, false, 0, 60, new Object[]{this.getMessage()}, "Transcriptionist");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Scheduled date / time");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OBR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDObservationRequest() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObr1_SetIDObservationRequest() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CM_PLACER getPlacerOrderNumber() {
        CM_PLACER retVal = (CM_PLACER)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_PLACER getObr2_PlacerOrderNumber() {
        CM_PLACER retVal = (CM_PLACER)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_FILLER getFillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(3, 0);
        return retVal;
    }

    public CM_FILLER getObr3_FillerOrderNumber() {
        CM_FILLER retVal = (CM_FILLER)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getUniversalServiceID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getObr4_UniversalServiceID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPriorityNotused() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getObr5_PriorityNotused() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRequestedDateTimeNotused() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObr6_RequestedDateTimeNotused() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObr7_ObservationDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getObr8_ObservationEndDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ_QUANTITY getCollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ_QUANTITY getObr9_CollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(9, 0);
        return retVal;
    }

    public CN[] getCollectorIdentifier() {
        CN[] retVal = (CN[])this.getTypedField(10, (Type[])new CN[0]);
        return retVal;
    }

    public CN[] getObr10_CollectorIdentifier() {
        CN[] retVal = (CN[])this.getTypedField(10, (Type[])new CN[0]);
        return retVal;
    }

    public int getCollectorIdentifierReps() {
        return this.getReps(10);
    }

    public CN getCollectorIdentifier(int rep) {
        CN retVal = (CN)this.getTypedField(10, rep);
        return retVal;
    }

    public CN getObr10_CollectorIdentifier(int rep) {
        CN retVal = (CN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getObr10_CollectorIdentifierReps() {
        return this.getReps(10);
    }

    public CN insertCollectorIdentifier(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN insertObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN removeCollectorIdentifier(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public CN removeObr10_CollectorIdentifier(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public ID getSpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObr11_SpecimenActionCode() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getDangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getObr12_DangerCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getObr13_RelevantClinicalInformation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getSpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getObr14_SpecimenReceivedDateTime() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public CM_SPS getSpecimenSource() {
        CM_SPS retVal = (CM_SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public CM_SPS getObr15_SpecimenSource() {
        CM_SPS retVal = (CM_SPS)this.getTypedField(15, 0);
        return retVal;
    }

    public CN getOrderingProvider() {
        CN retVal = (CN)this.getTypedField(16, 0);
        return retVal;
    }

    public CN getObr16_OrderingProvider() {
        CN retVal = (CN)this.getTypedField(16, 0);
        return retVal;
    }

    public TN[] getOrderCallbackPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(17, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getObr17_OrderCallbackPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(17, (Type[])new TN[0]);
        return retVal;
    }

    public int getOrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public TN getOrderCallbackPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(17, rep);
        return retVal;
    }

    public TN getObr17_OrderCallbackPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(17, rep);
        return retVal;
    }

    public int getObr17_OrderCallbackPhoneNumberReps() {
        return this.getReps(17);
    }

    public TN insertOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN insertObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN removeOrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public TN removeObr17_OrderCallbackPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public ST getPlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getObr18_PlacerField1() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getPlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getObr19_PlacerField2() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getFillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getObr20_FillerField1() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getFillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getObr21_FillerField2() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public TS getResultsReportStatusChangeDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public TS getObr22_ResultsReportStatusChangeDateTime() {
        TS retVal = (TS)this.getTypedField(22, 0);
        return retVal;
    }

    public CM_MOC getChargeToPractice() {
        CM_MOC retVal = (CM_MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public CM_MOC getObr23_ChargeToPractice() {
        CM_MOC retVal = (CM_MOC)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDiagnosticServiceSectionID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getObr24_DiagnosticServiceSectionID() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getObr25_ResultStatus() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public CM_PARENT_RESULT getParentResult() {
        CM_PARENT_RESULT retVal = (CM_PARENT_RESULT)this.getTypedField(26, 0);
        return retVal;
    }

    public CM_PARENT_RESULT getObr26_ParentResult() {
        CM_PARENT_RESULT retVal = (CM_PARENT_RESULT)this.getTypedField(26, 0);
        return retVal;
    }

    public TQ[] getQuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(27, (Type[])new TQ[0]);
        return retVal;
    }

    public TQ[] getObr27_QuantityTiming() {
        TQ[] retVal = (TQ[])this.getTypedField(27, (Type[])new TQ[0]);
        return retVal;
    }

    public int getQuantityTimingReps() {
        return this.getReps(27);
    }

    public TQ getQuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(27, rep);
        return retVal;
    }

    public TQ getObr27_QuantityTiming(int rep) {
        TQ retVal = (TQ)this.getTypedField(27, rep);
        return retVal;
    }

    public int getObr27_QuantityTimingReps() {
        return this.getReps(27);
    }

    public TQ insertQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(27, rep);
    }

    public TQ insertObr27_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(27, rep);
    }

    public TQ removeQuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(27, rep);
    }

    public TQ removeObr27_QuantityTiming(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(27, rep);
    }

    public CN[] getResultCopiesTo() {
        CN[] retVal = (CN[])this.getTypedField(28, (Type[])new CN[0]);
        return retVal;
    }

    public CN[] getObr28_ResultCopiesTo() {
        CN[] retVal = (CN[])this.getTypedField(28, (Type[])new CN[0]);
        return retVal;
    }

    public int getResultCopiesToReps() {
        return this.getReps(28);
    }

    public CN getResultCopiesTo(int rep) {
        CN retVal = (CN)this.getTypedField(28, rep);
        return retVal;
    }

    public CN getObr28_ResultCopiesTo(int rep) {
        CN retVal = (CN)this.getTypedField(28, rep);
        return retVal;
    }

    public int getObr28_ResultCopiesToReps() {
        return this.getReps(28);
    }

    public CN insertResultCopiesTo(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN insertObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN removeResultCopiesTo(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CN removeObr28_ResultCopiesTo(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CM_EIP getParentNumber() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public CM_EIP getObr29_ParentNumber() {
        CM_EIP retVal = (CM_EIP)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getTransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getObr30_TransportationMode() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CE[] getReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getObr31_ReasonForStudy() {
        CE[] retVal = (CE[])this.getTypedField(31, (Type[])new CE[0]);
        return retVal;
    }

    public int getReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE getReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public CE getObr31_ReasonForStudy(int rep) {
        CE retVal = (CE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getObr31_ReasonForStudyReps() {
        return this.getReps(31);
    }

    public CE insertReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeObr31_ReasonForStudy(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CM_NDL getPrincipalResultInterpreter() {
        CM_NDL retVal = (CM_NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public CM_NDL getObr32_PrincipalResultInterpreter() {
        CM_NDL retVal = (CM_NDL)this.getTypedField(32, 0);
        return retVal;
    }

    public CM_NDL[] getAssistantResultInterpreter() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(33, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr33_AssistantResultInterpreter() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(33, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public int getAssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public CM_NDL getAssistantResultInterpreter(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public CM_NDL getObr33_AssistantResultInterpreter(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(33, rep);
        return retVal;
    }

    public int getObr33_AssistantResultInterpreterReps() {
        return this.getReps(33);
    }

    public CM_NDL insertAssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(33, rep);
    }

    public CM_NDL insertObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(33, rep);
    }

    public CM_NDL removeAssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(33, rep);
    }

    public CM_NDL removeObr33_AssistantResultInterpreter(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(33, rep);
    }

    public CM_NDL[] getTechnician() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(34, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr34_Technician() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(34, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public int getTechnicianReps() {
        return this.getReps(34);
    }

    public CM_NDL getTechnician(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public CM_NDL getObr34_Technician(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(34, rep);
        return retVal;
    }

    public int getObr34_TechnicianReps() {
        return this.getReps(34);
    }

    public CM_NDL insertTechnician(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(34, rep);
    }

    public CM_NDL insertObr34_Technician(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(34, rep);
    }

    public CM_NDL removeTechnician(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(34, rep);
    }

    public CM_NDL removeObr34_Technician(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(34, rep);
    }

    public CM_NDL[] getTranscriptionist() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(35, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public CM_NDL[] getObr35_Transcriptionist() {
        CM_NDL[] retVal = (CM_NDL[])this.getTypedField(35, (Type[])new CM_NDL[0]);
        return retVal;
    }

    public int getTranscriptionistReps() {
        return this.getReps(35);
    }

    public CM_NDL getTranscriptionist(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public CM_NDL getObr35_Transcriptionist(int rep) {
        CM_NDL retVal = (CM_NDL)this.getTypedField(35, rep);
        return retVal;
    }

    public int getObr35_TranscriptionistReps() {
        return this.getReps(35);
    }

    public CM_NDL insertTranscriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(35, rep);
    }

    public CM_NDL insertObr35_Transcriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.insertRepetition(35, rep);
    }

    public CM_NDL removeTranscriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(35, rep);
    }

    public CM_NDL removeObr35_Transcriptionist(int rep) throws HL7Exception {
        return (CM_NDL)super.removeRepetition(35, rep);
    }

    public TS getScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    public TS getObr36_ScheduledDateTime() {
        TS retVal = (TS)this.getTypedField(36, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CM_PLACER(this.getMessage());
            }
            case 2: {
                return new CM_FILLER(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CQ_QUANTITY(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(65));
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CM_SPS(this.getMessage());
            }
            case 15: {
                return new CN(this.getMessage());
            }
            case 16: {
                return new TN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new CM_MOC(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new CM_PARENT_RESULT(this.getMessage());
            }
            case 26: {
                return new TQ(this.getMessage());
            }
            case 27: {
                return new CN(this.getMessage());
            }
            case 28: {
                return new CM_EIP(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new CM_NDL(this.getMessage());
            }
            case 32: {
                return new CM_NDL(this.getMessage());
            }
            case 33: {
                return new CM_NDL(this.getMessage());
            }
            case 34: {
                return new CM_NDL(this.getMessage());
            }
            case 35: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

