/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.segment.LCC;
import ca.uhn.hl7v2.model.v23.segment.LCH;
import ca.uhn.hl7v2.model.v23.segment.LDP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M05_MF_LOC_DEPT
extends AbstractGroup {
    public MFN_M05_MF_LOC_DEPT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(LDP.class, true, false, false);
            this.add(LCH.class, false, true, false);
            this.add(LCC.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M05_MF_LOC_DEPT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public LDP getLDP() {
        LDP retVal = (LDP)this.getTyped("LDP", LDP.class);
        return retVal;
    }

    public LCH getLCH() {
        LCH retVal = (LCH)this.getTyped("LCH", LCH.class);
        return retVal;
    }

    public LCH getLCH(int rep) {
        LCH retVal = (LCH)this.getTyped("LCH", rep, LCH.class);
        return retVal;
    }

    public int getLCHReps() {
        return this.getReps("LCH");
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", (Structure)structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LCC getLCC() {
        LCC retVal = (LCC)this.getTyped("LCC", LCC.class);
        return retVal;
    }

    public LCC getLCC(int rep) {
        LCC retVal = (LCC)this.getTyped("LCC", rep, LCC.class);
        return retVal;
    }

    public int getLCCReps() {
        return this.getReps("LCC");
    }

    public List<LCC> getLCCAll() throws HL7Exception {
        return this.getAllAsList("LCC", LCC.class);
    }

    public void insertLCC(LCC structure, int rep) throws HL7Exception {
        super.insertRepetition("LCC", (Structure)structure, rep);
    }

    public LCC insertLCC(int rep) throws HL7Exception {
        return (LCC)super.insertRepetition("LCC", rep);
    }

    public LCC removeLCC(int rep) throws HL7Exception {
        return (LCC)super.removeRepetition("LCC", rep);
    }
}

