/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.MFN_M02_MFESTFPRA;
import ca.uhn.hl7v2.model.v231.segment.MFI;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M02
extends AbstractMessage {
    public MFN_M02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public MFN_M02() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M02_MFESTFPRA.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M02_MFESTFPRA getMFESTFPRA() {
        MFN_M02_MFESTFPRA ret = null;
        try {
            ret = (MFN_M02_MFESTFPRA)this.get("MFESTFPRA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M02_MFESTFPRA getMFESTFPRA(int rep) {
        MFN_M02_MFESTFPRA ret = null;
        try {
            ret = (MFN_M02_MFESTFPRA)this.get("MFESTFPRA", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMFESTFPRAReps() {
        int reps = -1;
        try {
            reps = this.getAll("MFESTFPRA").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMFESTFPRA(MFN_M02_MFESTFPRA structure, int rep) throws HL7Exception {
        super.insertRepetition("MFESTFPRA", (Structure)structure, rep);
    }

    public MFN_M02_MFESTFPRA insertMFESTFPRA(int rep) throws HL7Exception {
        return (MFN_M02_MFESTFPRA)super.insertRepetition("MFESTFPRA", rep);
    }

    public MFN_M02_MFESTFPRA removeMFESTFPRA(int rep) throws HL7Exception {
        return (MFN_M02_MFESTFPRA)super.removeRepetition("MFESTFPRA", rep);
    }
}

