/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.MFN_M15_MF_INV_ITEM;
import ca.uhn.hl7v2.model.v251.segment.MFI;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M15
extends AbstractMessage {
    public MFN_M15() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M15(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M15_MF_INV_ITEM.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M15 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M15_MF_INV_ITEM getMF_INV_ITEM() {
        return (MFN_M15_MF_INV_ITEM)this.getTyped("MF_INV_ITEM", MFN_M15_MF_INV_ITEM.class);
    }

    public MFN_M15_MF_INV_ITEM getMF_INV_ITEM(int rep) {
        return (MFN_M15_MF_INV_ITEM)this.getTyped("MF_INV_ITEM", rep, MFN_M15_MF_INV_ITEM.class);
    }

    public int getMF_INV_ITEMReps() {
        return this.getReps("MF_INV_ITEM");
    }

    public List<MFN_M15_MF_INV_ITEM> getMF_INV_ITEMAll() throws HL7Exception {
        return this.getAllAsList("MF_INV_ITEM", MFN_M15_MF_INV_ITEM.class);
    }

    public void insertMF_INV_ITEM(MFN_M15_MF_INV_ITEM structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_INV_ITEM", (Structure)structure, rep);
    }

    public MFN_M15_MF_INV_ITEM insertMF_INV_ITEM(int rep) throws HL7Exception {
        return (MFN_M15_MF_INV_ITEM)super.insertRepetition("MF_INV_ITEM", rep);
    }

    public MFN_M15_MF_INV_ITEM removeMF_INV_ITEM(int rep) throws HL7Exception {
        return (MFN_M15_MF_INV_ITEM)super.removeRepetition("MF_INV_ITEM", rep);
    }
}

