/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.sms;

import cn.javaer.aliyun.sms.BatchSmsTemplate;
import cn.javaer.aliyun.sms.SmsException;
import cn.javaer.aliyun.sms.SmsTemplate;
import com.aliyuncs.CommonResponse;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

class Utils {
    private static final String SUCCESS_CODE = "OK";
    private static final String PHONE_NUMBER_REGEX = "\\d{5,}";

    Utils() {
    }

    static int randomCode() {
        return 100000 + ThreadLocalRandom.current().nextInt(900000);
    }

    static String toJsonStr(Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append('\"').append(entry.getKey().replace("\"", "\\\"")).append('\"').append(':').append('\"').append(entry.getValue().replace("\"", "\\\"")).append('\"').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    static void checkSmsTemplate(SmsTemplate template) {
        Utils.checkNotEmpty(template.getSignName(), "SmsTemplate signName must be not empty");
        Utils.checkNotEmpty(template.getTemplateCode(), "SmsTemplate templateCode must be not empty");
        Utils.checkNotEmpty(template.getPhoneNumbers(), "SmsTemplate phoneNumbers must be not empty");
    }

    static void checkBatchSmsTemplate(BatchSmsTemplate template) {
        Utils.checkNotEmpty(template.getSignNames(), "BatchSmsTemplate signNames must be not empty");
        Utils.checkNotEmpty(template.getPhoneNumbers(), "BatchSmsTemplate phoneNumbers must be not empty");
        Utils.checkNotEmpty(template.getTemplateCode(), "BatchSmsTemplate templateCode must be not empty");
        Utils.checkNotEmpty(template.getTemplateParams(), "BatchSmsTemplate templateParams must be not empty");
        if (template.getSignNames().size() != template.getPhoneNumbers().size() && template.getPhoneNumbers().size() != template.getTemplateParams().size()) {
            throw new IllegalArgumentException("BatchSmsTemplate phoneNumbers, signNames, templateParams size must be the same");
        }
    }

    static void checkSmsResponse(CommonResponse response) {
        if (null == response) {
            throw new SmsException("Response is null");
        }
        Gson gson = new Gson();
        Map json = (Map)gson.fromJson(response.getData(), Map.class);
        if (!SUCCESS_CODE.equalsIgnoreCase((String)json.get("Code"))) {
            throw new SmsException("Http status: " + response.getHttpStatus() + ", response: " + response.getData());
        }
    }

    static void checkPhoneNumber(String phoneNumber) {
        if (null == phoneNumber || !phoneNumber.matches(PHONE_NUMBER_REGEX)) {
            throw new IllegalArgumentException("Invalid phone number");
        }
    }

    static void checkNotEmpty(String str, String message) {
        if (null == str || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    static void checkNotEmpty(Collection coll, String message) {
        if (null == coll || coll.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }
}

