/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.modulemaker;

import codes.rafael.modulemaker.Provide;
import codes.rafael.modulemaker.QualifiedPackage;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

public abstract class AbstractModuleMojo
extends AbstractMojo {
    @Parameter(name="java-version", defaultValue="9")
    private int javaVersion;
    @Parameter(required=true)
    private String name;
    @Parameter
    private String version;
    @Parameter(required=true, defaultValue="false")
    private boolean multirelease;
    @Parameter
    private String packages;
    @Parameter
    private String requires;
    @Parameter(name="static-requires")
    private String staticRequires;
    @Parameter
    private String exports;
    @Parameter
    private String opens;
    @Parameter(name="qualified-exports")
    private List<QualifiedPackage> qualifiedExports;
    @Parameter(name="qualified-opens")
    private List<QualifiedPackage> qualifiedOpens;
    @Parameter(name="main-class")
    private String mainClass;
    @Parameter
    private String uses;
    @Parameter
    private List<Provide> provides;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.javaVersion < 9) {
            throw new MojoExecutionException("Invalid Java version for module-info: " + this.javaVersion);
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected String filename() {
        return (this.multirelease ? "META-INF/versions/" + this.javaVersion + "/" : "") + "module-info.class";
    }

    protected byte[] makeModuleInfo() throws MojoExecutionException {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(44 + this.javaVersion, 32768, "module-info", null, null, null);
        ModuleVisitor moduleVisitor = classWriter.visitModule(this.name, 0, this.version);
        if (this.packages != null) {
            HashSet<String> previousPackages = new HashSet<String>();
            for (String aPackage : this.packages.split(",")) {
                if (!previousPackages.add(aPackage.trim())) {
                    throw new MojoExecutionException("Duplicate package: " + aPackage.trim());
                }
                moduleVisitor.visitPackage(aPackage.trim().replace('.', '/'));
            }
        }
        HashSet<String> previousRequires = new HashSet<String>();
        if (this.requires != null) {
            for (String module : this.requires.split(",")) {
                if (!previousRequires.add(module.trim())) {
                    throw new MojoExecutionException("Duplicate require: " + module.trim());
                }
                moduleVisitor.visitRequire(module.trim(), 0, null);
            }
        }
        if (this.staticRequires != null) {
            for (String module : this.staticRequires.split(",")) {
                if (!previousRequires.add(module.trim())) {
                    throw new MojoExecutionException("Duplicate require: " + module.trim());
                }
                moduleVisitor.visitRequire(module.trim(), 64, null);
            }
        }
        if (!previousRequires.contains("java.base")) {
            moduleVisitor.visitRequire("java.base", 32768, null);
        }
        HashSet<String> previousExports = new HashSet<String>();
        if (this.exports != null) {
            for (String aPackage : this.exports.split(",")) {
                if (!previousExports.add(aPackage.trim())) {
                    throw new MojoExecutionException("Duplicate export: " + aPackage.trim());
                }
                moduleVisitor.visitExport(aPackage.trim().replace('.', '/'), 0, (String[])null);
            }
        }
        if (this.qualifiedExports != null) {
            for (QualifiedPackage qualifiedPackage : this.qualifiedExports) {
                String[] modules = qualifiedPackage.modules.split(",");
                HashSet<String> previousModules = new HashSet<String>();
                for (int index = 0; index < modules.length; ++index) {
                    if (!previousModules.add(modules[index].trim())) {
                        throw new MojoExecutionException("Duplicate module: " + modules[index].trim());
                    }
                    modules[index] = modules[index].trim();
                }
                for (String aPackage : qualifiedPackage.packages.split(",")) {
                    if (!previousExports.add(aPackage.trim())) {
                        throw new MojoExecutionException("Duplicate export: " + aPackage.trim());
                    }
                    moduleVisitor.visitExport(aPackage.trim().replace('.', '/'), 0, modules);
                }
            }
        }
        HashSet<String> previousOpens = new HashSet<String>();
        if (this.opens != null) {
            for (String aPackage : this.opens.split(",")) {
                if (!previousOpens.add(aPackage.trim())) {
                    throw new MojoExecutionException("Duplicate export: " + aPackage.trim());
                }
                moduleVisitor.visitOpen(aPackage.trim().replace('.', '/'), 0, (String[])null);
            }
        }
        if (this.qualifiedOpens != null) {
            for (QualifiedPackage qualifiedPackage : this.qualifiedOpens) {
                String[] modules = qualifiedPackage.modules.split(",");
                HashSet<String> previousModules = new HashSet<String>();
                for (int index = 0; index < modules.length; ++index) {
                    if (!previousModules.add(modules[index].trim())) {
                        throw new MojoExecutionException("Duplicate module: " + modules[index].trim());
                    }
                    modules[index] = modules[index].trim();
                }
                for (String aPackage : qualifiedPackage.packages.split(",")) {
                    if (!previousOpens.add(aPackage.trim())) {
                        throw new MojoExecutionException("Duplicate export: " + aPackage.trim());
                    }
                    moduleVisitor.visitOpen(aPackage.trim().replace('.', '/'), 0, modules);
                }
            }
        }
        if (this.mainClass != null) {
            moduleVisitor.visitMainClass(this.mainClass.trim());
        }
        if (this.uses != null) {
            HashSet<String> previousUses = new HashSet<String>();
            for (String type : this.uses.split(",")) {
                if (!previousUses.add(type.trim())) {
                    throw new MojoExecutionException("Duplicate use: " + type.trim());
                }
                moduleVisitor.visitUse(type.trim().replace('.', '/'));
            }
        }
        if (this.provides != null) {
            HashSet<String> previousServices = new HashSet<String>();
            for (Provide provide : this.provides) {
                String[] providers = provide.providers.split(",");
                HashSet<String> previousProviders = new HashSet<String>();
                for (int index = 0; index < providers.length; ++index) {
                    if (!previousProviders.add(providers[index].trim())) {
                        throw new MojoExecutionException("Duplicate provider: " + providers[index].trim());
                    }
                    providers[index] = providers[index].trim().replace('.', '/');
                }
                for (String type : provide.services.split(",")) {
                    if (!previousServices.add(type.trim())) {
                        throw new MojoExecutionException("Duplicate service: " + type.trim());
                    }
                    moduleVisitor.visitProvide(type.trim().replace('.', '/'), providers);
                }
            }
        }
        moduleVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }
}

