/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.common;

import com.aizuda.snailjob.server.common.allocate.common.HashFunction;
import com.aizuda.snailjob.server.common.allocate.common.Node;
import com.aizuda.snailjob.server.common.allocate.common.VirtualNode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashRouter<T extends Node> {
    private final SortedMap<Long, VirtualNode<T>> ring = new TreeMap<Long, VirtualNode<T>>();
    private final HashFunction hashFunction;

    public ConsistentHashRouter(Collection<T> pNodes, int vNodeCount) {
        this(pNodes, vNodeCount, new MD5Hash());
    }

    public ConsistentHashRouter(Collection<T> pNodes, int vNodeCount, HashFunction hashFunction) {
        if (hashFunction == null) {
            throw new NullPointerException("Hash Function is null");
        }
        this.hashFunction = hashFunction;
        if (pNodes != null) {
            for (Node pNode : pNodes) {
                this.addNode(pNode, vNodeCount);
            }
        }
    }

    public void addNode(T pNode, int vNodeCount) {
        if (vNodeCount < 0) {
            throw new IllegalArgumentException("illegal virtual node counts :" + vNodeCount);
        }
        int existingReplicas = this.getExistingReplicas(pNode);
        for (int i = 0; i < vNodeCount; ++i) {
            VirtualNode<T> vNode = new VirtualNode<T>(pNode, i + existingReplicas);
            this.ring.put(this.hashFunction.hash(vNode.getKey()), vNode);
        }
    }

    public void removeNode(T pNode) {
        Iterator<Long> it = this.ring.keySet().iterator();
        while (it.hasNext()) {
            Long key = it.next();
            VirtualNode virtualNode = (VirtualNode)this.ring.get(key);
            if (!virtualNode.isVirtualNodeOf(pNode)) continue;
            it.remove();
        }
    }

    public T routeNode(String objectKey) {
        if (this.ring.isEmpty()) {
            return null;
        }
        Long hashVal = this.hashFunction.hash(objectKey);
        SortedMap<Long, VirtualNode<T>> tailMap = this.ring.tailMap(hashVal);
        Long nodeHashVal = !tailMap.isEmpty() ? tailMap.firstKey() : this.ring.firstKey();
        return ((VirtualNode)this.ring.get(nodeHashVal)).getPhysicalNode();
    }

    public int getExistingReplicas(T pNode) {
        int replicas = 0;
        for (VirtualNode<T> vNode : this.ring.values()) {
            if (!vNode.isVirtualNodeOf(pNode)) continue;
            ++replicas;
        }
        return replicas;
    }

    private static class MD5Hash
    implements HashFunction {
        MessageDigest instance;

        public MD5Hash() {
            try {
                this.instance = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }

        @Override
        public long hash(String key) {
            this.instance.reset();
            this.instance.update(key.getBytes());
            byte[] digest = this.instance.digest();
            long h = 0L;
            for (int i = 0; i < 4; ++i) {
                h <<= 8;
                h |= (long)(digest[i] & 0xFF);
            }
            return h;
        }
    }
}

