/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.generator.id;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.server.common.generator.id.Segment;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SegmentBuffer {
    private Pair<String, String> key;
    private Segment[] segments = new Segment[]{new Segment(this), new Segment(this)};
    private volatile int currentPos = 0;
    private volatile boolean nextReady = false;
    private volatile boolean initOk = false;
    private final AtomicBoolean threadRunning = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int step;
    private volatile int minStep;
    private volatile long updateTimestamp;

    public Pair<String, String> getKey() {
        return this.key;
    }

    public void setKey(Pair<String, String> key) {
        this.key = key;
    }

    public Segment[] getSegments() {
        return this.segments;
    }

    public Segment getCurrent() {
        return this.segments[this.currentPos];
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public int nextPos() {
        return (this.currentPos + 1) % 2;
    }

    public void switchPos() {
        this.currentPos = this.nextPos();
    }

    public boolean isInitOk() {
        return this.initOk;
    }

    public void setInitOk(boolean initOk) {
        this.initOk = initOk;
    }

    public boolean isNextReady() {
        return this.nextReady;
    }

    public void setNextReady(boolean nextReady) {
        this.nextReady = nextReady;
    }

    public AtomicBoolean getThreadRunning() {
        return this.threadRunning;
    }

    public Lock rLock() {
        return this.lock.readLock();
    }

    public Lock wLock() {
        return this.lock.writeLock();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getMinStep() {
        return this.minStep;
    }

    public void setMinStep(int minStep) {
        this.minStep = minStep;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SegmentBuffer{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", segments=").append(Arrays.toString(this.segments));
        sb.append(", currentPos=").append(this.currentPos);
        sb.append(", nextReady=").append(this.nextReady);
        sb.append(", initOk=").append(this.initOk);
        sb.append(", threadRunning=").append(this.threadRunning);
        sb.append(", step=").append(this.step);
        sb.append(", minStep=").append(this.minStep);
        sb.append(", updateTimestamp=").append(this.updateTimestamp);
        sb.append('}');
        return sb.toString();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void setSegments(Segment[] segments) {
        this.segments = segments;
    }

    public void setCurrentPos(int currentPos) {
        this.currentPos = currentPos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentBuffer)) {
            return false;
        }
        SegmentBuffer other = (SegmentBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentPos() != other.getCurrentPos()) {
            return false;
        }
        if (this.isNextReady() != other.isNextReady()) {
            return false;
        }
        if (this.isInitOk() != other.isInitOk()) {
            return false;
        }
        if (this.getStep() != other.getStep()) {
            return false;
        }
        if (this.getMinStep() != other.getMinStep()) {
            return false;
        }
        if (this.getUpdateTimestamp() != other.getUpdateTimestamp()) {
            return false;
        }
        Pair<String, String> this$key = this.getKey();
        Pair<String, String> other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSegments(), other.getSegments())) {
            return false;
        }
        AtomicBoolean this$threadRunning = this.getThreadRunning();
        AtomicBoolean other$threadRunning = other.getThreadRunning();
        if (this$threadRunning == null ? other$threadRunning != null : !this$threadRunning.equals(other$threadRunning)) {
            return false;
        }
        ReadWriteLock this$lock = this.getLock();
        ReadWriteLock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SegmentBuffer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentPos();
        result = result * 59 + (this.isNextReady() ? 79 : 97);
        result = result * 59 + (this.isInitOk() ? 79 : 97);
        result = result * 59 + this.getStep();
        result = result * 59 + this.getMinStep();
        long $updateTimestamp = this.getUpdateTimestamp();
        result = result * 59 + (int)($updateTimestamp >>> 32 ^ $updateTimestamp);
        Pair<String, String> $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSegments());
        AtomicBoolean $threadRunning = this.getThreadRunning();
        result = result * 59 + ($threadRunning == null ? 43 : $threadRunning.hashCode());
        ReadWriteLock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }
}

