/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.util;

import com.aizuda.snailjob.server.common.dto.PartitionTask;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import org.springframework.util.CollectionUtils;

public class PartitionTaskUtils {
    private PartitionTaskUtils() {
    }

    public static long process(LongFunction<List<? extends PartitionTask>> dataSource, Consumer<List<? extends PartitionTask>> task, long startId) {
        return PartitionTaskUtils.process(dataSource, task, curStartId -> {}, CollectionUtils::isEmpty, startId);
    }

    public static long process(LongFunction<List<? extends PartitionTask>> dataSource, Consumer<List<? extends PartitionTask>> task, Predicate<List<? extends PartitionTask>> stopCondition, long startId) {
        return PartitionTaskUtils.process(dataSource, task, curStartId -> {}, stopCondition, startId);
    }

    public static long process(LongFunction<List<? extends PartitionTask>> dataSource, Consumer<List<? extends PartitionTask>> task, LongConsumer stopAfterProcessor, long startId) {
        return PartitionTaskUtils.process(dataSource, task, stopAfterProcessor, CollectionUtils::isEmpty, startId);
    }

    public static long process(LongFunction<List<? extends PartitionTask>> dataSource, Consumer<List<? extends PartitionTask>> task, LongConsumer stopAfterProcessor, Predicate<List<? extends PartitionTask>> stopCondition, long startId) {
        List<? extends PartitionTask> products;
        int total = 0;
        do {
            if (stopCondition.test(products = dataSource.apply(startId))) {
                stopAfterProcessor.accept(startId);
                break;
            }
            total += products.size();
            task.accept(products);
        } while ((startId = PartitionTaskUtils.maxId(products)) > 0L);
        return total;
    }

    private static long maxId(List<? extends PartitionTask> products) {
        return products.get(products.size() - 1).getId() + 1L;
    }
}

