/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.NettyResult;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.enums.TaskGeneratorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.model.dto.RetryTaskDTO;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskContext;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskGenerator;
import com.aizuda.snailjob.server.retry.task.service.TaskContextConverter;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReportRetryInfoHttpRequestHandler
extends PostHttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ReportRetryInfoHttpRequestHandler.class);
    @Autowired
    private List<TaskGenerator> taskGenerators;

    public boolean supports(String path) {
        return "/batch/report".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Transactional
    public String doHandler(String content, UrlQuery urlQuery, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Batch Report Retry Data. content:[{}]", new Object[]{content});
        final SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        try {
            TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.CLIENT_REPORT.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("\u6ca1\u6709\u5339\u914d\u7684\u4efb\u52a1\u751f\u6210\u5668"));
            Assert.notEmpty((Object[])args, () -> new SnailJobServerException("\u4e0a\u62a5\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a. reqId:[{}]", new Object[]{retryRequest.getReqId()}));
            List retryTaskList = JsonUtil.parseList((String)JsonUtil.toJsonString((Object)args[0]), RetryTaskDTO.class);
            SnailJobLog.LOCAL.info("begin handler report data. <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)retryTaskList)});
            Set set = StreamUtils.toSet((Collection)retryTaskList, RetryTaskDTO::getGroupName);
            Assert.isTrue((set.size() <= 1 ? 1 : 0) != 0, () -> new SnailJobServerException("\u6279\u91cf\u4e0a\u62a5\u6570\u636e,\u540c\u4e00\u6279\u6b21\u53ea\u80fd\u662f\u76f8\u540c\u7684\u7ec4. reqId:[{}]", new Object[]{retryRequest.getReqId()}));
            Map map = StreamUtils.groupByKey((Collection)retryTaskList, RetryTaskDTO::getSceneName);
            Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> throwable instanceof DuplicateKeyException || throwable instanceof TransactionSystemException || throwable instanceof ConcurrencyFailureException || throwable instanceof IOException).withStopStrategy(StopStrategies.stopAfterAttempt((int)5)).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withRetryListener(new RetryListener(){

                public <V> void onRetry(Attempt<V> attempt) {
                    if (attempt.hasException()) {
                        SnailJobLog.LOCAL.error("\u6570\u636e\u4e0a\u62a5\u53d1\u751f\u5f02\u5e38\u6267\u884c\u91cd\u8bd5. reqId:[{}] count:[{}]", new Object[]{retryRequest.getReqId(), attempt.getAttemptNumber(), attempt.getExceptionCause()});
                    }
                }
            }).build();
            String namespaceId = headers.getAsString((CharSequence)HeadersEnum.NAMESPACE.getKey());
            retryer.call(() -> {
                map.forEach((sceneName, retryTaskDTOS) -> {
                    TaskContext taskContext = new TaskContext();
                    taskContext.setSceneName((String)sceneName);
                    taskContext.setNamespaceId(namespaceId);
                    taskContext.setGroupName((String)set.stream().findFirst().get());
                    taskContext.setTaskInfos(TaskContextConverter.INSTANCE.toTaskContextInfo((List<RetryTaskDTO>)retryTaskDTOS));
                    taskGenerator.taskGenerator(taskContext);
                });
                return null;
            });
            return JsonUtil.toJsonString((Object)new NettyResult(StatusEnum.YES.getStatus().intValue(), "Batch Retry Data Upload Processed Successfully", (Object)Boolean.TRUE, retryRequest.getReqId()));
        }
        catch (Exception e) {
            Throwable throwable2 = e;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                RetryException re = (RetryException)e;
                throwable2 = re.getLastFailedAttempt().getExceptionCause();
            }
            SnailJobLog.LOCAL.error("Batch Report Retry Data Error. <|>{}<|>", new Object[]{args[0], throwable2});
            return JsonUtil.toJsonString((Object)new NettyResult(StatusEnum.YES.getStatus().intValue(), throwable2.getMessage(), (Object)Boolean.FALSE, retryRequest.getReqId()));
        }
    }
}

