/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskActuatorFactory;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.timer.AbstractTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Objects;

public class CallbackTimerTask
extends AbstractTimerTask {
    public static final String IDEMPOTENT_KEY_PREFIX = "callback_{0}_{1}_{2}";
    private final RetryTimerContext context;

    public CallbackTimerTask(RetryTimerContext context) {
        this.context = context;
        this.groupName = context.getGroupName();
        this.uniqueId = context.getUniqueId();
        this.namespaceId = context.getNamespaceId();
    }

    @Override
    protected void doRun(Timeout timeout) {
        SnailJobLog.LOCAL.debug("\u56de\u8c03\u4efb\u52a1\u6267\u884c {}", new Object[]{LocalDateTime.now()});
        AccessTemplate accessTemplate = (AccessTemplate)SnailSpringContext.getBeanByType(AccessTemplate.class);
        TaskAccess retryTaskAccess = accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(this.context.getGroupName(), this.context.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)this.context.getNamespaceId())).eq(RetryTask::getGroupName, (Object)this.context.getGroupName())).eq(RetryTask::getUniqueId, (Object)this.context.getUniqueId())).eq(RetryTask::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus()));
        if (Objects.isNull(retryTask)) {
            return;
        }
        TaskExecutor taskExecutor = TaskActuatorFactory.getTaskActuator(this.context.getScene());
        taskExecutor.actuator(retryTask);
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.context.getGroupName(), this.context.getNamespaceId(), this.context.getUniqueId());
    }
}

