/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.client;

import com.alibaba.cloudapi.sdk.client.ApacheIdleConnectionCleaner;
import com.alibaba.cloudapi.sdk.client.BaseApiClient;
import com.alibaba.cloudapi.sdk.enums.HttpConnectionModel;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.alibaba.cloudapi.sdk.util.SignUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends BaseApiClient {
    private static final int DEFAULT_THREAD_KEEP_ALIVE_TIME = 60;
    private ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;

    protected ApacheHttpClient() {
    }

    public void init(HttpClientBuilderParams params) {
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout((int)params.getReadTimeout()).build();
        Registry<ConnectionSocketFactory> registry = ApacheHttpClient.getRegistry();
        if (params.getRegistry() != null) {
            registry = params.getRegistry();
        }
        this.connectionManager = new PoolingHttpClientConnectionManager(registry);
        this.connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().build());
        this.connectionManager.setDefaultSocketConfig(socketConfig);
        this.connectionManager.setMaxTotal(params.getDispatchMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(params.getDispatchMaxRequestsPerHost());
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout((int)params.getConnectionTimeout()).setSocketTimeout((int)params.getReadTimeout()).setConnectionRequestTimeout((int)params.getReadTimeout()).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(defaultConfig).build();
        ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, params.getMaxIdleTimeMillis());
        this.appKey = params.getAppKey();
        this.appSecret = params.getAppSecret();
        this.host = params.getHost();
        this.scheme = params.getScheme();
        this.executorService = params.getExecutorService() == null ? new ThreadPoolExecutor(0, params.getDispatchMaxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DeafultAsyncThreadFactory()) : params.getExecutorService();
    }

    private static Registry<ConnectionSocketFactory> getRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        try {
            registryBuilder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(SSLContext.getDefault(), (HostnameVerifier)new DefaultHostnameVerifier()));
        }
        catch (Exception e) {
            throw new RuntimeException("HttpClientUtil init failure !", e);
        }
        return registryBuilder.build();
    }

    private static Registry<ConnectionSocketFactory> getNoVerifyRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        try {
            registryBuilder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(KeyStore.getInstance(KeyStore.getDefaultType()), new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build(), new HostnameVerifier(){

                @Override
                public boolean verify(String paramString, SSLSession paramSSLSession) {
                    return true;
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("HttpClientUtil init failure !", e);
        }
        return registryBuilder.build();
    }

    private HttpUriRequest buildRequest(ApiRequest apiRequest) {
        if (apiRequest.getHttpConnectionMode() == HttpConnectionModel.SINGER_CONNECTION) {
            apiRequest.setHost(this.host);
            apiRequest.setScheme(this.scheme);
        }
        ApiRequestMaker.make(apiRequest, this.appKey, this.appSecret);
        RequestBuilder builder = RequestBuilder.create((String)apiRequest.getMethod().getValue());
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(apiRequest.getScheme().name());
            uriBuilder.setHost(apiRequest.getHost());
            uriBuilder.setPath(apiRequest.getPath());
            if (!HttpCommonUtil.isEmpty(apiRequest.getQuerys())) {
                for (Map.Entry<String, String> entry : apiRequest.getQuerys().entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            builder.setUri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            throw new SdkException("build http request uri failed", e);
        }
        EntityBuilder bodyBuilder = EntityBuilder.create();
        bodyBuilder.setContentType(ContentType.parse((String)apiRequest.getMethod().getRequestContentType()));
        if (!HttpCommonUtil.isEmpty(apiRequest.getFormParams())) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : apiRequest.getFormParams().entrySet()) {
                paramList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            bodyBuilder.setParameters(paramList);
            builder.setEntity(bodyBuilder.build());
        } else if (!HttpCommonUtil.isEmpty(apiRequest.getBody())) {
            bodyBuilder.setBinary(apiRequest.getBody());
            builder.setEntity(bodyBuilder.build());
        }
        for (Map.Entry<String, Object> entry : apiRequest.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                builder.addHeader(entry.getKey(), value);
            }
        }
        return builder.build();
    }

    private ApiResponse parseToApiResponse(HttpResponse httpResponse) throws IOException {
        ApiResponse result = new ApiResponse(httpResponse.getStatusLine().getStatusCode());
        result.setHeaders(new HashMap<String, List<String>>());
        for (Header header : httpResponse.getAllHeaders()) {
            List<String> values = result.getHeaders().get(header.getName());
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(header.getValue());
            result.getHeaders().put(header.getName().toLowerCase(), values);
        }
        result.setMessage(httpResponse.getStatusLine().getReasonPhrase());
        if (httpResponse.getEntity() != null) {
            String localContentMd5;
            Header contentType = httpResponse.getEntity().getContentType();
            if (contentType != null) {
                result.setContentType(contentType.getValue());
            } else {
                result.setContentType("application/text; charset=utf-8");
            }
            result.setBody(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
            String contentMD5 = result.getFirstHeaderValue("x-ca-content-md5");
            if (null != contentMD5 && !"".equals(contentMD5) && !contentMD5.equalsIgnoreCase(localContentMd5 = SignUtil.base64AndMD5(result.getBody()))) {
                throw new SdkException("Server Content MD5 does not match body content , server md5 is " + contentMD5 + "  local md5 is " + localContentMd5 + " body is " + new String(result.getBody()));
            }
        } else {
            String contentTypeStr = result.getFirstHeaderValue("content-type");
            if (null == contentTypeStr) {
                contentTypeStr = "application/text; charset=utf-8";
            }
            result.setContentType(contentTypeStr);
        }
        return result;
    }

    @Override
    public final ApiResponse sendSyncRequest(ApiRequest apiRequest) {
        ApiResponse apiResponse;
        HttpUriRequest httpRequest = this.buildRequest(apiRequest);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute(httpRequest);
            apiResponse = this.parseToApiResponse((HttpResponse)httpResponse);
        }
        catch (IOException e) {
            try {
                throw new SdkException(e);
            }
            catch (Throwable throwable) {
                HttpCommonUtil.closeQuietly(httpResponse);
                throw throwable;
            }
        }
        HttpCommonUtil.closeQuietly((Closeable)httpResponse);
        return apiResponse;
    }

    @Override
    public final void sendAsyncRequest(final ApiRequest apiRequest, final ApiCallback apiCallback) {
        final long start = System.currentTimeMillis();
        this.executorService.submit(new Callable<ApiResponse>(){

            @Override
            public ApiResponse call() throws Exception {
                ApiResponse apiResponse;
                try {
                    apiResponse = ApacheHttpClient.this.sendSyncRequest(apiRequest);
                }
                catch (Exception e) {
                    if (apiCallback != null) {
                        apiCallback.onFailure(apiRequest, e);
                    }
                    throw e;
                }
                if (apiCallback != null) {
                    long latency = System.currentTimeMillis() - start;
                    apiResponse.addHeader("X-CA-LATENCY", String.valueOf(latency));
                    apiCallback.onResponse(apiRequest, apiResponse);
                }
                return apiResponse;
            }
        });
    }

    public void shutdown() {
        this.executorService.shutdown();
        ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
        this.connectionManager.shutdown();
        HttpCommonUtil.closeQuietly((Closeable)this.httpClient);
    }

    private class DeafultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DeafultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Aliyun_SDK_Async_ThreadPool_" + this.counter.incrementAndGet());
        }
    }
}

