/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.model;

import com.alibaba.cloudapi.sdk.enums.HttpConnectionModel;
import com.alibaba.cloudapi.sdk.enums.HttpMethod;
import com.alibaba.cloudapi.sdk.enums.ParamPosition;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.enums.WebSocketApiType;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiHttpMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ApiRequest
extends ApiHttpMessage {
    private Scheme scheme;
    private HttpMethod method;
    private String host;
    private String path;
    private String url;
    private String signatureMethod = "HmacSHA256";
    private Date currentDate;
    private boolean isBase64BodyViaWebsocket = false;
    private HttpConnectionModel httpConnectionMode = HttpConnectionModel.SINGER_CONNECTION;
    private WebSocketApiType webSocketApiType = WebSocketApiType.COMMON;
    private Map<String, String> pathParams = new HashMap<String, String>();
    private Map<String, String> querys = new HashMap<String, String>();
    private Map<String, String> formParams = new HashMap<String, String>();

    public ApiRequest(HttpMethod method, String path) {
        this.scheme = this.scheme;
        this.host = this.host;
        this.method = method;
        this.path = path;
    }

    public ApiRequest(HttpMethod method, String path, byte[] body) {
        this.scheme = this.scheme;
        this.host = this.host;
        this.method = method;
        this.path = path;
        this.body = body;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public Map<String, String> getQuerys() {
        return this.querys;
    }

    public Map<String, String> getFormParams() {
        return this.formParams;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addParam(String name, String value, ParamPosition position, boolean isRequired) {
        if (value == null) {
            if (isRequired) {
                throw new SdkException(String.format("param %s is not nullable, please check your codes", name));
            }
            return;
        }
        Map<String, String> targetParamMap = null;
        switch (position) {
            case HEAD: {
                this.addHeader(name, value);
                return;
            }
            case PATH: {
                targetParamMap = this.pathParams;
                break;
            }
            case QUERY: {
                targetParamMap = this.querys;
                break;
            }
            case BODY: {
                targetParamMap = this.formParams;
                break;
            }
            default: {
                throw new SdkException("unknown param position: " + (Object)((Object)position));
            }
        }
        if (value instanceof String) {
            targetParamMap.put(name, value);
        } else {
            targetParamMap.put(name, value.toString());
        }
    }

    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public void setQuerys(Map<String, String> querys) {
        this.querys = querys;
    }

    public void setFormParams(Map<String, String> formParams) {
        this.formParams = formParams;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public HttpConnectionModel getHttpConnectionMode() {
        return this.httpConnectionMode;
    }

    public void setHttpConnectionMode(HttpConnectionModel httpConnectionMode) {
        this.httpConnectionMode = httpConnectionMode;
    }

    public WebSocketApiType getWebSocketApiType() {
        return this.webSocketApiType;
    }

    public void setWebSocketApiType(WebSocketApiType webSocketApiType) {
        this.webSocketApiType = webSocketApiType;
    }

    public boolean isBase64BodyViaWebsocket() {
        return this.isBase64BodyViaWebsocket;
    }

    public void setBase64BodyViaWebsocket(boolean base64BodyViaWebsocket) {
        this.isBase64BodyViaWebsocket = base64BodyViaWebsocket;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public ApiRequest duplicate() {
        ApiRequest apiRequest = new ApiRequest(this.method, this.path, this.body);
        if (null != this.host) {
            apiRequest.host = new String(this.host);
        }
        if (null != this.url) {
            apiRequest.url = new String(this.url);
        }
        apiRequest.pathParams = new HashMap<String, String>();
        apiRequest.pathParams.putAll(this.pathParams);
        apiRequest.headers = new HashMap();
        apiRequest.headers.putAll(this.headers);
        apiRequest.querys = new HashMap<String, String>();
        apiRequest.querys.putAll(this.querys);
        apiRequest.formParams = new HashMap<String, String>();
        apiRequest.formParams.putAll(this.formParams);
        if (null != this.signatureMethod) {
            apiRequest.signatureMethod = new String(this.signatureMethod);
        }
        apiRequest.webSocketApiType = this.webSocketApiType;
        apiRequest.httpConnectionMode = this.httpConnectionMode;
        apiRequest.isBase64BodyViaWebsocket = this.isBase64BodyViaWebsocket;
        return apiRequest;
    }
}

