/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.model;

import com.alibaba.cloudapi.sdk.constant.SdkConstant;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ApiHttpMessage {
    protected byte[] body;
    protected String bodyStr;
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public String getBodyStr() {
        return this.bodyStr;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        name = name.trim().toLowerCase();
        this.addParam(name, value, this.headers);
    }

    protected void addParam(String name, String value, Map<String, List<String>> map) {
        if (map.containsKey(name)) {
            map.get(name).add(value);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value == null ? "" : value.trim());
            map.put(name, values);
        }
    }

    public String getFirstHeaderValue(String name) {
        if (this.headers.containsKey(name) && this.headers.get(name).size() > 0) {
            return this.headers.get(name).get(0);
        }
        return null;
    }

    public void parse(JSONObject message) {
        JSONObject headers = message.getJSONObject("header");
        for (Map.Entry header : headers.entrySet()) {
            if (header.getValue() instanceof String) {
                this.addHeader((String)header.getKey(), (String)header.getValue());
                continue;
            }
            if (!(header.getValue() instanceof List)) continue;
            List values = (List)header.getValue();
            for (String value : values) {
                this.addHeader((String)header.getKey(), value);
            }
        }
        String contentType = headers.getString("content-type");
        Charset charset = SdkConstant.CLOUDAPI_ENCODING;
        if (null != contentType) {
            try {
                contentType = contentType.toLowerCase();
                String[] charsetStr = contentType.split(";");
                for (int i = 0; i < charsetStr.length; ++i) {
                    if (!charsetStr[i].contains("charset")) continue;
                    charset = Charset.forName(charsetStr[i].substring(charsetStr[i].indexOf("=")));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.bodyStr = message.getString("body");
        this.body = this.bodyStr.getBytes(charset);
    }
}

