/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.model;

import com.alibaba.cloudapi.sdk.constant.SdkConstant;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ApiHttpMessage {
    protected byte[] body;
    protected String bodyStr;
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public String getBodyStr() {
        return this.bodyStr;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        name = name.trim().toLowerCase();
        this.addParam(name, value, this.headers);
    }

    protected void addParam(String name, String value, Map<String, List<String>> map) {
        if (map.containsKey(name)) {
            map.get(name).add(value);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value == null ? "" : value.trim());
            map.put(name, values);
        }
    }

    public String getFirstHeaderValue(String name) {
        if (this.headers.containsKey(name) && this.headers.get(name).size() > 0) {
            return this.headers.get(name).get(0);
        }
        return null;
    }

    public void parse(JsonNode message) {
        JsonNode bodyNode;
        JsonNode headers = message.get("header");
        if (headers != null && headers.size() > 0) {
            Iterator names = headers.fieldNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (headers.get(name) == null) continue;
                if (headers.get(name).size() > 0) {
                    for (JsonNode value : headers.get(name)) {
                        this.addHeader(name, value.asText());
                    }
                    continue;
                }
                this.addHeader(name, headers.get(name).asText());
            }
        }
        String contentType = this.getFirstHeaderValue("content-type");
        Charset charset = SdkConstant.CLOUDAPI_ENCODING;
        if (null != contentType) {
            try {
                contentType = contentType.toLowerCase();
                String[] charsetStr = contentType.split(";");
                for (int i = 0; i < charsetStr.length; ++i) {
                    if (!charsetStr[i].contains("charset")) continue;
                    charset = Charset.forName(charsetStr[i].substring(charsetStr[i].indexOf("=") + 1));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((bodyNode = message.get("body")) != null) {
            this.bodyStr = bodyNode.asText();
            this.body = this.bodyStr.getBytes(charset);
        }
    }
}

