/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartitionSpec {
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private Map<String, String> kv = new LinkedHashMap<String, String>();

    public PartitionSpec() {
    }

    public PartitionSpec(String spec) {
        String[] groups;
        if (spec == null) {
            throw new IllegalArgumentException("Argument 'spec' cannot be null");
        }
        for (String group : groups = spec.split("[,/]")) {
            String[] kv = group.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException("Invalid partition spec.");
            }
            String k = kv[0].trim();
            String v = kv[1].trim().replaceAll("'", "").replaceAll("\"", "");
            if (k.length() == 0 || v.length() == 0) {
                throw new IllegalArgumentException("Invalid partition spec.");
            }
            this.set(k, v);
        }
    }

    public void set(String key, String value) {
        this.kv.put(key, value);
    }

    public String get(String key) {
        return this.kv.get(key);
    }

    public Set<String> keys() {
        return this.kv.keySet();
    }

    public boolean isEmpty() {
        return this.kv.isEmpty();
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean quote, boolean useSlashDelimiter) {
        String[] keys;
        String delimiter = useSlashDelimiter ? SLASH : COMMA;
        LinkedList<String> entries = new LinkedList<String>();
        for (String key : keys = this.keys().toArray(new String[0])) {
            StringBuilder entryBuilder = new StringBuilder();
            entryBuilder.append(key).append("=");
            if (quote) {
                entryBuilder.append("'").append(this.kv.get(key)).append("'");
            } else {
                entryBuilder.append(this.kv.get(key));
            }
            entries.add(entryBuilder.toString());
        }
        return String.join((CharSequence)delimiter, entries);
    }
}

