/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.AbstractPrimitiveTypeInfo;

public class DecimalTypeInfo
extends AbstractPrimitiveTypeInfo {
    static final int DEFAULT_PRECISION = 54;
    static final int DEFAULT_SCALE = 18;
    private int precision;
    private int scale;

    DecimalTypeInfo() {
        this(54, 18);
    }

    DecimalTypeInfo(int precision, int scale) {
        super(OdpsType.DECIMAL);
        this.validateParameter(precision, scale);
        this.precision = precision;
        this.scale = scale;
    }

    private void validateParameter(int precision, int scale) {
        if (precision < 1) {
            throw new IllegalArgumentException("Decimal precision < 1");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("Decimal scale < 0");
        }
        if (scale > precision) {
            throw new IllegalArgumentException("Decimal precision must be larger than or equal to scale");
        }
    }

    @Override
    public String getTypeName() {
        if (this.precision == 54 && this.scale == 18) {
            return super.getTypeName();
        }
        return String.format("%s(%s,%s)", super.getTypeName(), this.precision, this.scale);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

