/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.aliyun.odps.commons.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class OSUtils {

  /**
   * Get OS name
   *
   * @return
   */
  public static String getOS() {
    return System.getProperties().getProperty("os.name");
  }

  public static String getIpAddress() {
    try {
      return InetAddress.getLocalHost().getHostAddress();
    } catch (UnknownHostException e) {
      return "unknown";
    }
  }

  public static String getMacAddress() {
    try {
      InetAddress address = InetAddress.getLocalHost();
      byte[] macAddressBytes = NetworkInterface.getByInetAddress(address).getHardwareAddress();
      // The MAC address may not exist, in this case, return "unknown" immediately
      if (macAddressBytes == null) {
        return "unknown";
      }

      StringBuilder macBuilder = new StringBuilder();
      for (int i = 0; i < macAddressBytes.length; i++) {
        macBuilder.append(String.format(
            "%02X%s", macAddressBytes[i], (i < macAddressBytes.length - 1) ? "-" : ""));
      }
      return macBuilder.toString();
    } catch (UnknownHostException e) {
      return "unknown";
    } catch (SocketException e) {
      return "unknown";
    } catch (NullPointerException e) {
      return "unknown";
    }
  }
}
