/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class OdpsShipperConfig
implements ShipperConfig {
    private String mOdpsEndPoint;
    private String mOdpsProject;
    private String mOdpsTable;
    private List<String> mLogFieldsList;
    private List<String> mPartitionColumn;
    private String mPartitionTimeFormat;
    private int mBufferInterval;

    public OdpsShipperConfig(String odpsEndPoint, String odpsProject, String odpsTable, List<String> logFieldsList, List<String> partitionColumn, String partitionTimeFormat) {
        this.mOdpsEndPoint = odpsEndPoint;
        this.mOdpsProject = odpsProject;
        this.mOdpsTable = odpsTable;
        this.mLogFieldsList = logFieldsList;
        this.mPartitionColumn = partitionColumn;
        this.mPartitionTimeFormat = partitionTimeFormat;
        this.mBufferInterval = 1800;
    }

    public OdpsShipperConfig() {
    }

    public String GetOdpsEndPoint() {
        return this.mOdpsEndPoint;
    }

    public String GetOdpsProject() {
        return this.mOdpsProject;
    }

    public String GetOdpsTable() {
        return this.mOdpsTable;
    }

    public List<String> GetLogFieldsList() {
        return new ArrayList<String>(this.mLogFieldsList);
    }

    public List<String> GetPartitionColumn() {
        return new ArrayList<String>(this.mPartitionColumn);
    }

    public String GetPartitionTimeFromat() {
        return this.mPartitionTimeFormat;
    }

    @Override
    public String GetShipperType() {
        return "odps";
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"odpsEndpoint", (Object)this.mOdpsEndPoint);
        obj.put((Object)"odpsProject", (Object)this.mOdpsProject);
        obj.put((Object)"odpsTable", (Object)this.mOdpsTable);
        obj.put((Object)"fields", this.mLogFieldsList);
        obj.put((Object)"partitionColumn", this.mPartitionColumn);
        obj.put((Object)"partitionTimeFormat", (Object)this.mPartitionTimeFormat);
        obj.put((Object)"bufferInterval", (Object)this.mBufferInterval);
        return obj;
    }

    private List<String> FromJsonArray(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(jsonArray.getString(i));
        }
        return list;
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.mOdpsEndPoint = obj.getString("odpsEndpoint");
            this.mOdpsProject = obj.getString("odpsProject");
            this.mOdpsTable = obj.getString("odpsTable");
            this.mLogFieldsList = this.FromJsonArray(obj.getJSONArray("fields"));
            this.mPartitionColumn = this.FromJsonArray(obj.getJSONArray("partitionColumn"));
            this.mPartitionTimeFormat = obj.getString("partitionTimeFormat");
            this.mBufferInterval = obj.getInt("bufferInterval");
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }
}

