/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.comm;

import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.ClientException;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.client.ServiceException;
import com.aliyun.openservices.log.http.comm.HttpMesssage;
import com.aliyun.openservices.log.http.comm.RequestMessage;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.http.utils.CodingUtils;
import com.aliyun.openservices.log.http.utils.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public abstract class ServiceClient {
    private static final int DEFAULT_MARK_LIMIT = 4096;
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, String charset) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(charset, "charset");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, charset);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseMessage sendRequestImpl(RequestMessage request, String charset) throws ClientException, ServiceException {
        ResponseMessage response = null;
        InputStream content = request.getContent();
        if (content != null && content.markSupported()) {
            content.mark(4096);
        }
        try {
            Request httpRequest = this.buildRequest(request, charset);
            response = this.sendRequestCore(httpRequest, charset);
            return response;
        }
        catch (ServiceException ex) {
            this.closeResponseSilently(response);
            throw ex;
        }
        catch (ClientException ex) {
            this.closeResponseSilently(response);
            throw ex;
        }
        catch (Exception ex) {
            this.closeResponseSilently(response);
            throw new ClientException(ex.getMessage(), ex);
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, String var2) throws Exception;

    private Request buildRequest(RequestMessage requestMessage, String charset) throws ClientException {
        boolean putParamsInUri;
        String paramString;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        try {
            paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
        }
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(charset);
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Request
    extends HttpMesssage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

