/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.JobConfiguration;
import com.aliyun.openservices.log.common.JobType;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.Utils;
import java.util.Date;

abstract class AbstractJob {
    @JSONField
    private String name;
    @JSONField
    private String displayName;
    @JSONField
    private String description;
    @JSONField
    private JobType type;
    @JSONField
    private boolean recyclable;
    private Date createTime;
    private Date lastModifiedTime;

    AbstractJob() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JobType getType() {
        return this.type;
    }

    protected void setType(JobType type) {
        this.type = type;
    }

    public boolean getRecyclable() {
        return this.recyclable;
    }

    public void setRecyclable(boolean recyclable) {
        this.recyclable = recyclable;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public abstract JobConfiguration getConfiguration();

    public void deserialize(JSONObject value) {
        this.name = value.getString("name");
        this.type = JobType.fromString(value.getString("type"));
        this.displayName = JsonUtils.readOptionalString(value, "displayName");
        this.description = JsonUtils.readOptionalString(value, "description");
        this.recyclable = JsonUtils.readBool(value, "recyclable", false);
        if (value.containsKey((Object)"createTime")) {
            this.createTime = Utils.timestampToDate(value.getLong("createTime"));
        }
        if (value.containsKey((Object)"lastModifiedTime")) {
            this.lastModifiedTime = Utils.timestampToDate(value.getLong("lastModifiedTime"));
        }
    }
}

