/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.Map;

public class Topostore
implements Serializable {
    private String name = "";
    private String tag = "{}";
    private String schema = null;
    private String acl = null;
    private String description = null;
    private String extInfo = null;
    private long createTime = 0L;
    private long lastModifyTime = 0L;

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public Topostore(String name, String tag, String schema, String acl, String description, String extInfo) {
        this.name = name;
        this.tag = tag;
        this.schema = schema;
        this.acl = acl;
        this.description = description;
        this.extInfo = extInfo;
    }

    public Topostore(String name, String tag) {
        this(name, tag, null, null, null, null);
    }

    public Topostore(String name) {
        this(name, "{}", null, null, null, null);
    }

    public Topostore() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTag(Map<String, String> tag) {
        if (tag == null) {
            return;
        }
        JSONObject tagObj = new JSONObject();
        for (Map.Entry<String, String> kv : tag.entrySet()) {
            tagObj.put(kv.getKey(), (Object)kv.getValue());
        }
        this.setTag(tagObj.toJSONString());
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getAcl() {
        return this.acl;
    }

    public void setAcl(String acl) {
        this.acl = acl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject result = new JSONObject();
        result.put("name", (Object)this.getName());
        result.put("tag", (Object)this.getTag());
        if (this.schema != null) {
            result.put("schema", (Object)this.getSchema());
        }
        if (this.description != null) {
            result.put("description", (Object)this.getDescription());
        }
        if (this.extInfo != null) {
            result.put("extInfo", (Object)this.getExtInfo());
        }
        if (this.acl != null) {
            result.put("acl", (Object)this.getAcl());
        }
        return result;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toJSONString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        this.setName(dict.getString("name"));
        this.setTag(dict.getString("tag"));
        if (dict.containsKey((Object)"description")) {
            this.setDescription(dict.getString("description"));
        }
        if (dict.containsKey((Object)"schema")) {
            this.setSchema(dict.getString("schema"));
            try {
                JSONObject.parseObject((String)dict.getString("schema"));
            }
            catch (JSONException e) {
                throw new LogException("BadResponse", "response topostore schema is not valid json", e, e.getMessage());
            }
        }
        if (dict.containsKey((Object)"acl")) {
            this.setAcl(dict.getString("acl"));
            try {
                JSONObject.parseObject((String)dict.getString("acl"));
            }
            catch (JSONException e) {
                throw new LogException("BadResponse", "response topostore acl is not valid json", e, e.getMessage());
            }
        }
        if (dict.containsKey((Object)"extInfo")) {
            this.setExtInfo(dict.getString("extInfo"));
        }
        if (dict.containsKey((Object)"createTime")) {
            this.createTime = dict.getIntValue("createTime");
        }
        if (dict.containsKey((Object)"lastModifyTime")) {
            this.lastModifyTime = dict.getIntValue("lastModifyTime");
        }
    }

    public void FromJsonString(String content) throws LogException {
        JSONObject dict = JSONObject.parseObject((String)content);
        this.FromJsonObject(dict);
    }

    public void checkForCreate() throws IllegalArgumentException {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("topostore name is null/empty");
        }
        if (this.schema != null) {
            try {
                JSONObject.parseObject((String)this.schema);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore schema not valid json");
            }
        }
        if (this.acl != null) {
            try {
                JSONObject.parseObject((String)this.acl);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore acl not valid json");
            }
        }
    }

    public void checkForUpsert() throws IllegalArgumentException {
        this.checkForCreate();
    }

    public void checkForUpdate() throws IllegalArgumentException {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("topostore name is null/empty");
        }
        if (this.schema != null) {
            try {
                JSONObject.parseObject((String)this.schema);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore schema not valid json");
            }
        }
        if (this.acl != null) {
            try {
                JSONObject.parseObject((String)this.acl);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore acl not valid json");
            }
        }
    }
}

