/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.aliyun.log.producer.example;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.common.auth.DefaultCredentials;
import com.aliyun.openservices.log.common.auth.StaticCredentialsProvider;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class ExampleUsage {
    public static void main(String[] args) throws ProducerException, InterruptedException, ExecutionException {
        String project = System.getenv("PROJECT");
        String endpoint = System.getenv("ENDPOINT");
        String logStore = System.getenv("LOG_STORE");
        LogProducer producer = new LogProducer(new ProducerConfig());
        ProjectConfig projectConfig = new ProjectConfig(project, endpoint, ExampleUsage.getCredentialsProvider(), null);
        producer.putProjectConfig(projectConfig);
        ListenableFuture<Result> f = producer.send(project, logStore, ExampleUsage.buildLogItem());
        Result result = (Result)f.get();
        System.out.println(result.isSuccessful());
        System.out.println(result.getErrorMessage());
        producer.send(project, logStore, null, null, ExampleUsage.buildLogItem());
        producer.send(System.getenv("PROJECT"), System.getenv("LOG_STORE"), "", "", ExampleUsage.buildLogItem());
        f = producer.send(project, logStore, "topic", "source", ExampleUsage.buildLogItem());
        result = (Result)f.get();
        System.out.println(result.isSuccessful());
        System.out.println(result.getErrorMessage());
        producer.close();
    }

    private static CredentialsProvider getCredentialsProvider() {
        String accessKeyId = System.getenv("ACCESS_KEY_ID");
        String accessKeySecret = System.getenv("ACCESS_KEY_SECRET");
        return new StaticCredentialsProvider((Credentials)new DefaultCredentials(accessKeyId, accessKeySecret));
    }

    public static LogItem buildLogItem() {
        LogItem logItem = new LogItem();
        logItem.PushBack("k1", "v1");
        logItem.PushBack("k2", "v2");
        return logItem;
    }

    public static List<LogItem> buildLogItems(int n) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        for (int i = 0; i < n; ++i) {
            logItems.add(ExampleUsage.buildLogItem());
        }
        return logItems;
    }
}

