/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.HttpTinyClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import java.io.IOException;

public class TopAddressing {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    private String nsAddr;
    private String wsAddr;
    private String unitName;

    public TopAddressing(String wsAddr) {
        this(wsAddr, null);
    }

    public TopAddressing(String wsAddr, String unitName) {
        this.wsAddr = wsAddr;
        this.unitName = unitName;
    }

    private static String clearNewLine(String str) {
        String newString = str.trim();
        int index = newString.indexOf("\r");
        if (index != -1) {
            return newString.substring(0, index);
        }
        index = newString.indexOf("\n");
        if (index != -1) {
            return newString.substring(0, index);
        }
        return newString;
    }

    public final String fetchNSAddr() {
        return this.fetchNSAddr(true, 3000L);
    }

    public final String fetchNSAddr(boolean verbose, long timeoutMills) {
        String url;
        block7: {
            url = this.wsAddr;
            try {
                if (!UtilAll.isBlank(this.unitName)) {
                    url = url + "-" + this.unitName + "?nofix=1";
                }
                HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(url, null, null, "UTF-8", timeoutMills);
                if (200 == result.code) {
                    String responseStr = result.content;
                    if (responseStr != null) {
                        return TopAddressing.clearNewLine(responseStr);
                    }
                    log.error("fetch nameserver address is null");
                } else {
                    log.error("fetch nameserver address failed. statusCode=" + result.code);
                }
            }
            catch (IOException e) {
                if (!verbose) break block7;
                log.error("fetch name server address exception", e);
            }
        }
        if (verbose) {
            String errorMsg = "connect to " + url + " failed, maybe the domain name " + MixAll.getWSAddr() + " not bind in /etc/hosts";
            errorMsg = errorMsg + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/");
            log.warn(errorMsg);
        }
        return null;
    }

    public String getNsAddr() {
        return this.nsAddr;
    }

    public void setNsAddr(String nsAddr) {
        this.nsAddr = nsAddr;
    }
}

