/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker07
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker07.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        URI wsURL = this.uri();
        String path = WebSocketClientHandshaker07.rawPath(wsURL);
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 07 client handshake key: {}, expected response: {}", (Object)key, (Object)this.expectedChallengeResponseString);
        }
        int wsPort = WebSocketClientHandshaker07.websocketPort(wsURL);
        String host = wsURL.getHost();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        HttpHeaders headers = request.headers();
        headers.add("Upgrade", (Object)"WebSocket").add("Connection", (Object)"Upgrade").add("Sec-WebSocket-Key", (Object)key).add("Host", (Object)host).add("Sec-WebSocket-Origin", (Object)WebSocketClientHandshaker07.websocketOriginValue(host, wsPort));
        String expectedSubprotocol = this.expectedSubprotocol();
        if (expectedSubprotocol != null && !expectedSubprotocol.isEmpty()) {
            headers.add("Sec-WebSocket-Protocol", (Object)expectedSubprotocol);
        }
        headers.add("Sec-WebSocket-Version", (Object)"7");
        if (this.customHeaders != null) {
            headers.add(this.customHeaders);
        }
        return request;
    }

    @Override
    protected void verify(FullHttpResponse response) {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders headers = response.headers();
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + response.getStatus());
        }
        String upgrade = headers.get("Upgrade");
        if (!"WebSocket".equalsIgnoreCase(upgrade)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + upgrade);
        }
        if (!headers.containsValue("Connection", "Upgrade", true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + headers.get("Connection"));
        }
        String accept = headers.get("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket07FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket07FrameEncoder(true);
    }
}

