/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerOrderly;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MessageQueueLock;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.stat.ConsumerStatsManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.CMResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.MessageUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.io.netty.util.internal.ConcurrentSet;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsumeMessageOrderlyService
implements ConsumeMessageService {
    private static final InternalLogger log = ClientLogger.getLog();
    private static final long MAX_TIME_CONSUME_CONTINUOUSLY = Long.parseLong(System.getProperty("rocketmq.client.maxTimeConsumeContinuously", "5000"));
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;
    private final DefaultMQPushConsumer defaultMQPushConsumer;
    private final MessageListenerOrderly messageListener;
    private final BlockingQueue<Runnable> consumeRequestQueue;
    private final ConcurrentSet<ConsumeRequest> consumeRequestSet = new ConcurrentSet();
    private final ThreadPoolExecutor consumeExecutor;
    private final String consumerGroup;
    private final MessageQueueLock messageQueueLock = new MessageQueueLock();
    private final MessageQueueLock consumeRequestLock = new MessageQueueLock();
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile boolean stopped = false;

    public ConsumeMessageOrderlyService(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl, MessageListenerOrderly messageListener) {
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
        this.messageListener = messageListener;
        this.defaultMQPushConsumer = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer();
        this.consumerGroup = this.defaultMQPushConsumer.getConsumerGroup();
        this.consumeRequestQueue = new LinkedBlockingQueue<Runnable>();
        this.consumeExecutor = new ThreadPoolExecutor(this.defaultMQPushConsumer.getConsumeThreadMin(), this.defaultMQPushConsumer.getConsumeThreadMax(), 60000L, TimeUnit.MILLISECONDS, this.consumeRequestQueue, new ThreadFactoryImpl("ConsumeMessageThread_"));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryImpl("ConsumeMessageScheduledThread_"));
    }

    @Override
    public void start() {
        if (MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) {
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ConsumeMessageOrderlyService.this.lockAllMessageQueues();
                }
            }, 1000L, ProcessQueue.REBALANCE_LOCK_INTERVAL, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void shutdown() {
        this.stopped = true;
        this.scheduledExecutorService.shutdown();
        this.consumeExecutor.shutdown();
        if (MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) {
            this.unlockAllMessageQueues();
        }
    }

    public synchronized void unlockAllMessageQueues() {
        this.defaultMQPushConsumerImpl.getRebalanceImpl().unlockAll(false);
    }

    @Override
    public void updateCorePoolSize(int corePoolSize) {
        if (corePoolSize > 0 && corePoolSize <= Short.MAX_VALUE && corePoolSize < this.defaultMQPushConsumer.getConsumeThreadMax()) {
            this.consumeExecutor.setCorePoolSize(corePoolSize);
        }
    }

    @Override
    public void incCorePoolSize() {
    }

    @Override
    public void decCorePoolSize() {
    }

    @Override
    public int getCorePoolSize() {
        return this.consumeExecutor.getCorePoolSize();
    }

    @Override
    public void allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.consumeExecutor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(MessageExt msg, String brokerName) {
        ConsumeMessageDirectlyResult result = new ConsumeMessageDirectlyResult();
        result.setOrder(true);
        ArrayList<MessageExt> msgs = new ArrayList<MessageExt>();
        msgs.add(msg);
        MessageQueue mq = new MessageQueue();
        mq.setBrokerName(brokerName);
        mq.setTopic(msg.getTopic());
        mq.setQueueId(msg.getQueueId());
        ConsumeOrderlyContext context = new ConsumeOrderlyContext(mq);
        this.defaultMQPushConsumerImpl.resetRetryAndNamespace(msgs, this.consumerGroup);
        long beginTime = System.currentTimeMillis();
        log.info("consumeMessageDirectly receive new message: {}", (Object)msg);
        try {
            ConsumeOrderlyStatus status = this.messageListener.consumeMessage(msgs, context);
            if (status != null) {
                switch (status) {
                    case COMMIT: {
                        result.setConsumeResult(CMResult.CR_COMMIT);
                        break;
                    }
                    case ROLLBACK: {
                        result.setConsumeResult(CMResult.CR_ROLLBACK);
                        break;
                    }
                    case SUCCESS: {
                        result.setConsumeResult(CMResult.CR_SUCCESS);
                        break;
                    }
                    case SUSPEND_CURRENT_QUEUE_A_MOMENT: {
                        result.setConsumeResult(CMResult.CR_LATER);
                        break;
                    }
                }
            } else {
                result.setConsumeResult(CMResult.CR_RETURN_NULL);
            }
        }
        catch (Throwable e) {
            result.setConsumeResult(CMResult.CR_THROW_EXCEPTION);
            result.setRemark(RemotingHelper.exceptionSimpleDesc(e));
            log.warn(String.format("consumeMessageDirectly exception: %s Group: %s Msgs: %s MQ: %s", RemotingHelper.exceptionSimpleDesc(e), this.consumerGroup, msgs, mq), e);
        }
        result.setAutoCommit(context.isAutoCommit());
        result.setSpentTimeMills(System.currentTimeMillis() - beginTime);
        log.info("consumeMessageDirectly Result: {}", (Object)result);
        return result;
    }

    @Override
    public void submitConsumeRequest(List<MessageExt> msgs, ProcessQueue processQueue, MessageQueue messageQueue) {
        if (this.defaultMQPushConsumer.isOrderlyConsumeAccelerator()) {
            int totalSize = this.defaultMQPushConsumer.getMaxConcurrencyForOrderQueue();
            Set<Integer> shardingKeyIndexSet = MessageUtils.getShardingKeyIndexes(msgs, totalSize);
            for (Integer shardingKeyIndex : shardingKeyIndexSet) {
                ConsumeRequest req = new ConsumeRequest(processQueue, messageQueue, shardingKeyIndex);
                this.submitConsumeRequest(req, false);
            }
        } else {
            ConsumeRequest req = new ConsumeRequest(processQueue, messageQueue);
            this.submitConsumeRequest(req, false);
        }
    }

    public synchronized void lockAllMessageQueues() {
        if (!this.stopped) {
            this.defaultMQPushConsumerImpl.getRebalanceImpl().lockAllMessageQueues();
        }
    }

    public void tryLockLaterAndReconsume(final ConsumeRequest consumeRequest, long delayMills) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                boolean lockOK = ConsumeMessageOrderlyService.this.lockOneMQ(consumeRequest.getMessageQueue());
                if (lockOK) {
                    ConsumeMessageOrderlyService.this.submitConsumeRequestLater(consumeRequest, 10L);
                } else {
                    ConsumeMessageOrderlyService.this.submitConsumeRequestLater(consumeRequest, 3000L);
                }
            }
        }, delayMills, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean lockOneMQ(MessageQueue mq) {
        if (!this.stopped) {
            return this.defaultMQPushConsumerImpl.getRebalanceImpl().lock(mq);
        }
        return false;
    }

    private void removeConsumeRequest(ConsumeRequest consumeRequest) {
        this.consumeRequestSet.remove(consumeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitConsumeRequest(ConsumeRequest consumeRequest, boolean force) {
        Object lock;
        Object object = lock = this.consumeRequestLock.fetchLockObject(consumeRequest.getMessageQueue(), consumeRequest.shardingKeyIndex);
        synchronized (object) {
            boolean isNewReq = this.consumeRequestSet.add(consumeRequest);
            if (force || isNewReq) {
                try {
                    this.consumeExecutor.submit(consumeRequest);
                }
                catch (Exception e) {
                    log.error("error submit consume request: {}, mq: {}, shardingKeyIndex: {}", e.toString(), consumeRequest.getMessageQueue(), consumeRequest.getShardingKeyIndex());
                }
            }
        }
    }

    private void submitConsumeRequestLater(final ConsumeRequest consumeRequest, long suspendTimeMillis) {
        long timeMillis = suspendTimeMillis;
        if (timeMillis == -1L) {
            timeMillis = this.defaultMQPushConsumer.getSuspendCurrentQueueTimeMillis();
        }
        if (timeMillis < 10L) {
            timeMillis = 10L;
        } else if (timeMillis > 30000L) {
            timeMillis = 30000L;
        }
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                ConsumeMessageOrderlyService.this.submitConsumeRequest(consumeRequest, true);
            }
        }, timeMillis, TimeUnit.MILLISECONDS);
    }

    public boolean processConsumeResult(List<MessageExt> msgs, ConsumeOrderlyStatus status, ConsumeOrderlyContext context, ConsumeRequest consumeRequest) {
        boolean continueConsume = true;
        long commitOffset = -1L;
        int shardIndex = consumeRequest.getShardingKeyIndex();
        if (context.isAutoCommit()) {
            switch (status) {
                case COMMIT: 
                case ROLLBACK: {
                    log.warn("the message queue consume result is illegal, we think you want to ack these message {}", (Object)consumeRequest.getMessageQueue());
                }
                case SUCCESS: {
                    commitOffset = consumeRequest.getProcessQueue().commit(msgs, shardIndex);
                    this.getConsumerStatsManager().incConsumeOKTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), msgs.size());
                    break;
                }
                case SUSPEND_CURRENT_QUEUE_A_MOMENT: {
                    this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), msgs.size());
                    if (this.checkReconsumeTimes(msgs)) {
                        consumeRequest.getProcessQueue().makeMessageToConsumeAgain(msgs, shardIndex);
                        this.submitConsumeRequestLater(consumeRequest, context.getSuspendCurrentQueueTimeMillis());
                        continueConsume = false;
                        break;
                    }
                    commitOffset = consumeRequest.getProcessQueue().commit(msgs, shardIndex);
                    break;
                }
            }
        } else {
            switch (status) {
                case SUCCESS: {
                    this.getConsumerStatsManager().incConsumeOKTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), msgs.size());
                    break;
                }
                case COMMIT: {
                    commitOffset = consumeRequest.getProcessQueue().commit(msgs, shardIndex);
                    break;
                }
                case ROLLBACK: {
                    consumeRequest.getProcessQueue().rollback(msgs, shardIndex);
                    this.submitConsumeRequestLater(consumeRequest, context.getSuspendCurrentQueueTimeMillis());
                    continueConsume = false;
                    break;
                }
                case SUSPEND_CURRENT_QUEUE_A_MOMENT: {
                    this.getConsumerStatsManager().incConsumeFailedTPS(this.consumerGroup, consumeRequest.getMessageQueue().getTopic(), msgs.size());
                    if (!this.checkReconsumeTimes(msgs)) break;
                    consumeRequest.getProcessQueue().makeMessageToConsumeAgain(msgs, shardIndex);
                    this.submitConsumeRequestLater(consumeRequest, context.getSuspendCurrentQueueTimeMillis());
                    continueConsume = false;
                    break;
                }
            }
        }
        if (commitOffset >= 0L && !consumeRequest.getProcessQueue().isDropped()) {
            this.defaultMQPushConsumerImpl.getOffsetStore().updateOffset(consumeRequest.getMessageQueue(), commitOffset, false);
        }
        return continueConsume;
    }

    public ConsumerStatsManager getConsumerStatsManager() {
        return this.defaultMQPushConsumerImpl.getConsumerStatsManager();
    }

    private int getMaxReconsumeTimes() {
        if (this.defaultMQPushConsumer.getMaxReconsumeTimes() == -1) {
            return Integer.MAX_VALUE;
        }
        return this.defaultMQPushConsumer.getMaxReconsumeTimes();
    }

    private boolean checkReconsumeTimes(List<MessageExt> msgs) {
        boolean suspend = false;
        if (msgs != null && !msgs.isEmpty()) {
            for (MessageExt msg : msgs) {
                if (msg.getReconsumeTimes() >= this.getMaxReconsumeTimes()) {
                    MessageAccessor.setReconsumeTime(msg, String.valueOf(msg.getReconsumeTimes()));
                    if (this.sendMessageBack(msg)) continue;
                    suspend = true;
                    msg.setReconsumeTimes(msg.getReconsumeTimes() + 1);
                    continue;
                }
                suspend = true;
                msg.setReconsumeTimes(msg.getReconsumeTimes() + 1);
            }
        }
        return suspend;
    }

    public boolean sendMessageBack(MessageExt msg) {
        try {
            Message newMsg = new Message(MixAll.getRetryTopic(this.defaultMQPushConsumer.getConsumerGroup()), msg.getBody());
            String originMsgId = MessageAccessor.getOriginMessageId(msg);
            MessageAccessor.setOriginMessageId(newMsg, UtilAll.isBlank(originMsgId) ? msg.getMsgId() : originMsgId);
            newMsg.setFlag(msg.getFlag());
            MessageAccessor.setProperties(newMsg, msg.getProperties());
            MessageAccessor.putProperty(newMsg, "RETRY_TOPIC", msg.getTopic());
            MessageAccessor.setReconsumeTime(newMsg, String.valueOf(msg.getReconsumeTimes()));
            MessageAccessor.setMaxReconsumeTimes(newMsg, String.valueOf(this.getMaxReconsumeTimes()));
            newMsg.setDelayTimeLevel(3 + msg.getReconsumeTimes());
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getDefaultMQProducer().send(newMsg);
            return true;
        }
        catch (Exception e) {
            log.error("sendMessageBack exception, group: " + this.consumerGroup + " msg: " + msg.toString(), e);
            return false;
        }
    }

    public void resetNamespace(List<MessageExt> msgs) {
        for (MessageExt msg : msgs) {
            if (!StringUtils.isNotEmpty(this.defaultMQPushConsumer.getNamespace())) continue;
            msg.setTopic(NamespaceUtil.withoutNamespace(msg.getTopic(), this.defaultMQPushConsumer.getNamespace()));
        }
    }

    class ConsumeRequest
    implements Runnable {
        private final ProcessQueue processQueue;
        private final MessageQueue messageQueue;
        private int shardingKeyIndex = 0;

        public ConsumeRequest(ProcessQueue processQueue, MessageQueue messageQueue) {
            this.processQueue = processQueue;
            this.messageQueue = messageQueue;
            this.shardingKeyIndex = 0;
        }

        public ConsumeRequest(ProcessQueue processQueue, MessageQueue messageQueue, int shardingKeyIndex) {
            this.processQueue = processQueue;
            this.messageQueue = messageQueue;
            this.shardingKeyIndex = shardingKeyIndex;
        }

        public ProcessQueue getProcessQueue() {
            return this.processQueue;
        }

        public MessageQueue getMessageQueue() {
            return this.messageQueue;
        }

        public int getShardingKeyIndex() {
            return this.shardingKeyIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object objLock;
            if (this.processQueue.isDropped()) {
                log.warn("run, message queue not be able to consume, because it's dropped. {}", (Object)this.messageQueue);
                ConsumeMessageOrderlyService.this.removeConsumeRequest(this);
                return;
            }
            Object object = objLock = ConsumeMessageOrderlyService.this.messageQueueLock.fetchLockObject(this.messageQueue, this.shardingKeyIndex);
            synchronized (object) {
                if (MessageModel.BROADCASTING.equals((Object)ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.messageModel()) || this.processQueue.isLocked() && !this.processQueue.isLockExpired()) {
                    long beginTime = System.currentTimeMillis();
                    boolean continueConsume = true;
                    int invokeCnt = 0;
                    while (continueConsume) {
                        List<MessageExt> msgs;
                        Object lock;
                        if (this.processQueue.isDropped()) {
                            log.warn("message queue not be able to consume, because it's dropped. {}", (Object)this.messageQueue);
                            ConsumeMessageOrderlyService.this.removeConsumeRequest(this);
                            break;
                        }
                        if (MessageModel.CLUSTERING.equals((Object)ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.messageModel()) && !this.processQueue.isLocked()) {
                            log.warn("message queue not locked, so consume later, {}", (Object)this.messageQueue);
                            ConsumeMessageOrderlyService.this.tryLockLaterAndReconsume(this, 10L);
                            break;
                        }
                        if (MessageModel.CLUSTERING.equals((Object)ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.messageModel()) && this.processQueue.isLockExpired()) {
                            log.warn("message queue lock expired, so consume later, {}", (Object)this.messageQueue);
                            ConsumeMessageOrderlyService.this.tryLockLaterAndReconsume(this, 10L);
                            break;
                        }
                        long interval = System.currentTimeMillis() - beginTime;
                        if (invokeCnt > 0 && interval > MAX_TIME_CONSUME_CONTINUOUSLY) {
                            ConsumeMessageOrderlyService.this.submitConsumeRequest(this, true);
                            break;
                        }
                        int consumeBatchSize = ConsumeMessageOrderlyService.this.defaultMQPushConsumer.getConsumeMessageBatchMaxSize();
                        Object object2 = lock = ConsumeMessageOrderlyService.this.consumeRequestLock.fetchLockObject(this.getMessageQueue(), this.shardingKeyIndex);
                        synchronized (object2) {
                            msgs = this.processQueue.takeMessagesByShardingKeyIndex(this.shardingKeyIndex, consumeBatchSize);
                            if (msgs.isEmpty()) {
                                ConsumeMessageOrderlyService.this.removeConsumeRequest(this);
                                break;
                            }
                        }
                        ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.resetRetryAndNamespace(msgs, ConsumeMessageOrderlyService.this.defaultMQPushConsumer.getConsumerGroup());
                        ConsumeOrderlyStatus status = null;
                        ConsumeMessageContext consumeMessageContext = null;
                        if (ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                            consumeMessageContext = new ConsumeMessageContext();
                            consumeMessageContext.setConsumerGroup(ConsumeMessageOrderlyService.this.defaultMQPushConsumer.getConsumerGroup());
                            consumeMessageContext.setNamespace(ConsumeMessageOrderlyService.this.defaultMQPushConsumer.getNamespace());
                            consumeMessageContext.setMq(this.messageQueue);
                            consumeMessageContext.setMsgList(msgs);
                            consumeMessageContext.setSuccess(false);
                            consumeMessageContext.setProps(new HashMap<String, String>());
                            ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.executeHookBefore(consumeMessageContext);
                        }
                        boolean hasException = false;
                        long beginTimestamp = System.currentTimeMillis();
                        ConsumeOrderlyContext context = new ConsumeOrderlyContext(this.messageQueue);
                        try {
                            this.processQueue.getLockConsume().readLock().lock();
                            if (this.processQueue.isDropped()) {
                                log.warn("consumeMessage, the message queue not be able to consume, because it's dropped. {}", (Object)this.messageQueue);
                                ConsumeMessageOrderlyService.this.removeConsumeRequest(this);
                                break;
                            }
                            status = ConsumeMessageOrderlyService.this.messageListener.consumeMessage(Collections.unmodifiableList(msgs), context);
                        }
                        catch (Throwable e) {
                            log.warn("consumeMessage exception: {} Group: {} Msgs: {} MQ: {}", RemotingHelper.exceptionSimpleDesc(e), ConsumeMessageOrderlyService.this.consumerGroup, msgs, this.messageQueue);
                            hasException = true;
                        }
                        finally {
                            this.processQueue.getLockConsume().readLock().unlock();
                        }
                        if (null == status || ConsumeOrderlyStatus.ROLLBACK == status || ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT == status) {
                            log.warn("consumeMessage Orderly return not OK, Group: {} Msgs: {} MQ: {}", ConsumeMessageOrderlyService.this.consumerGroup, msgs, this.messageQueue);
                        }
                        long consumeRT = System.currentTimeMillis() - beginTimestamp;
                        ConsumeReturnType returnType = ConsumeReturnType.SUCCESS;
                        if (null == status) {
                            returnType = hasException ? ConsumeReturnType.EXCEPTION : ConsumeReturnType.RETURNNULL;
                        } else if (consumeRT >= ConsumeMessageOrderlyService.this.defaultMQPushConsumer.getConsumeTimeout() * 60L * 1000L) {
                            returnType = ConsumeReturnType.TIME_OUT;
                        } else if (ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT == status) {
                            returnType = ConsumeReturnType.FAILED;
                        } else if (ConsumeOrderlyStatus.SUCCESS == status) {
                            returnType = ConsumeReturnType.SUCCESS;
                        }
                        if (ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                            consumeMessageContext.getProps().put("ConsumeContextType", returnType.name());
                        }
                        if (null == status) {
                            status = ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                        }
                        if (ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.hasHook()) {
                            consumeMessageContext.setStatus(status.toString());
                            consumeMessageContext.setSuccess(ConsumeOrderlyStatus.SUCCESS == status || ConsumeOrderlyStatus.COMMIT == status);
                            ConsumeMessageOrderlyService.this.defaultMQPushConsumerImpl.executeHookAfter(consumeMessageContext);
                        }
                        ConsumeMessageOrderlyService.this.getConsumerStatsManager().incConsumeRT(ConsumeMessageOrderlyService.this.consumerGroup, this.messageQueue.getTopic(), consumeRT);
                        continueConsume = ConsumeMessageOrderlyService.this.processConsumeResult(msgs, status, context, this);
                        ++invokeCnt;
                    }
                } else {
                    if (this.processQueue.isDropped()) {
                        log.warn("message queue not be able to consume, because it's dropped. {}", (Object)this.messageQueue);
                        ConsumeMessageOrderlyService.this.removeConsumeRequest(this);
                        return;
                    }
                    ConsumeMessageOrderlyService.this.tryLockLaterAndReconsume(this, 100L);
                }
            }
        }

        public int hashCode() {
            int hash = this.shardingKeyIndex;
            if (this.processQueue != null) {
                hash += this.processQueue.hashCode() * 31;
            }
            if (this.messageQueue != null) {
                hash += this.messageQueue.hashCode() * 31;
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsumeRequest other = (ConsumeRequest)obj;
            if (this.shardingKeyIndex != other.shardingKeyIndex) {
                return false;
            }
            if (this.processQueue != other.processQueue) {
                return false;
            }
            if (this.messageQueue == other.messageQueue) {
                return true;
            }
            return this.messageQueue != null && this.messageQueue.equals(other.messageQueue);
        }
    }
}

