/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class ProcessQueueGroup {
    private List<ProcessQueue> processQueueList;

    public ProcessQueueGroup() {
        this.processQueueList = new ArrayList<ProcessQueue>();
    }

    public ProcessQueueGroup(List<ProcessQueue> processQueueList) {
        this.processQueueList = processQueueList;
    }

    public List<ProcessQueue> getProcessQueueList() {
        return this.processQueueList;
    }

    public ProcessQueueGroupStatus getProcessQueueStatus() {
        int droppedCnt = 0;
        for (ProcessQueue pq : this.processQueueList) {
            if (!pq.isDropped()) continue;
            ++droppedCnt;
        }
        if (droppedCnt == 0) {
            return ProcessQueueGroupStatus.NOT_DROPPED;
        }
        if (droppedCnt == this.processQueueList.size()) {
            return ProcessQueueGroupStatus.ALL_DROPPED;
        }
        return ProcessQueueGroupStatus.PARTIALLY_DROPPED;
    }

    public boolean isLocked() {
        for (ProcessQueue pq : this.processQueueList) {
            if (pq.isLocked()) continue;
            return false;
        }
        return true;
    }

    public boolean isLockExpired() {
        for (ProcessQueue pq : this.processQueueList) {
            if (!pq.isLockExpired()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessQueueGroup that = (ProcessQueueGroup)o;
        return Objects.equal(this.processQueueList, that.processQueueList);
    }

    public int hashCode() {
        return Objects.hashCode(this.processQueueList);
    }

    public static enum ProcessQueueGroupStatus {
        ALL_DROPPED,
        PARTIALLY_DROPPED,
        NOT_DROPPED;

    }
}

