/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.ServiceThread;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.RequestTask;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.qos.QoS;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class NettyRemotingAbstract {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final AtomicLong PROCESS_REQUEST_EXCEPTION_FREQUENCY = new AtomicLong(0L);
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap<Integer, ResponseFuture>(256);
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyEventExecutor nettyEventExecutor = new NettyEventExecutor();
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessor;
    protected volatile SslContext sslContext;

    public NettyRemotingAbstract(int permitsOneway, int permitsAsync) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
    }

    public abstract ChannelEventListener getChannelEventListener();

    public void putNettyEvent(NettyEvent event) {
        this.nettyEventExecutor.putNettyEvent(event);
    }

    public void processMessageReceived(ChannelHandlerContext ctx, RemotingCommand command) {
        if (command != null) {
            switch (command.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(ctx, command);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(ctx, command);
                    break;
                }
            }
        }
    }

    public void processRequestCommand(final ChannelHandlerContext ctx, final RemotingCommand cmd) {
        Pair<NettyRequestProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        final Pair<NettyRequestProcessor, ExecutorService> pair = null == matched ? this.defaultRequestProcessor : matched;
        final int opaque = cmd.getOpaque();
        if (pair != null) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Exception exception = null;
                    try {
                        RemotingCommand response;
                        List<RPCHook> rpcHookList = NettyRemotingAbstract.this.getRPCHook();
                        try {
                            if (!rpcHookList.isEmpty()) {
                                for (RPCHook rpcHook : rpcHookList) {
                                    rpcHook.doBeforeRequest(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd);
                                }
                            }
                        }
                        catch (Exception e) {
                            exception = e;
                        }
                        if (exception == null) {
                            response = ((NettyRequestProcessor)pair.getObject1()).processRequest(ctx, cmd);
                        } else {
                            response = RemotingCommand.createResponseCommand(null);
                            response.setCode(1);
                        }
                        if (!rpcHookList.isEmpty()) {
                            for (RPCHook rpcHook : rpcHookList) {
                                rpcHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd, response);
                            }
                        }
                        if (exception != null) {
                            throw exception;
                        }
                        if (!cmd.isOnewayRPC() && response != null) {
                            response.setOpaque(opaque);
                            response.markResponseType();
                            try {
                                final RemotingCommand finalResponse = response;
                                ctx.writeAndFlush(response).addListener(new ChannelFutureListener(){

                                    @Override
                                    public void operationComplete(ChannelFuture future) {
                                        if (future.isSuccess()) {
                                            log.debug("Response[code={}, opaque={}] is written to network buffer", (Object)finalResponse.getCode(), (Object)finalResponse.getOpaque());
                                        } else {
                                            log.info("Failed to write response[code={}, opaque={}] to network buffer", (Object)finalResponse.getCode(), (Object)finalResponse.getOpaque());
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                log.error("process request over, but response failed", e);
                                log.error(cmd.toString());
                                log.error(response.toString());
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (PROCESS_REQUEST_EXCEPTION_FREQUENCY.getAndIncrement() % 1024L == 0L) {
                            log.error("process request exception", e);
                            log.error(cmd.toString());
                        }
                        if (!cmd.isOnewayRPC()) {
                            RemotingCommand response = RemotingCommand.createResponseCommand(1, RemotingHelper.exceptionSimpleDesc(e));
                            response.setOpaque(opaque);
                            ctx.writeAndFlush(response);
                        }
                    }
                    finally {
                        cmd.release();
                    }
                }
            };
            if (pair.getObject1().rejectRequest()) {
                cmd.release();
                RemotingCommand response = RemotingCommand.createResponseCommand(2, "[REQUEST-REJECTED]system busy, start flow control for a while");
                response.setOpaque(opaque);
                ctx.writeAndFlush(response);
                return;
            }
            try {
                RequestTask requestTask = new RequestTask(run, ctx.channel(), cmd);
                pair.getObject2().submit(requestTask);
            }
            catch (RejectedExecutionException e) {
                cmd.release();
                if (System.currentTimeMillis() % 10000L == 0L) {
                    log.warn(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getObject2().toString() + " request code: " + cmd.getCode());
                }
                if (!cmd.isOnewayRPC()) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(2, "[OVERLOAD]system busy, start flow control for a while");
                    response.setOpaque(opaque);
                    ctx.writeAndFlush(response);
                }
            }
            catch (Throwable e) {
                cmd.release();
            }
        } else {
            cmd.release();
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(3, error);
            response.setOpaque(opaque);
            ctx.writeAndFlush(response);
            log.error(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + error);
        }
    }

    public void processResponseCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        int opaque = cmd.getOpaque();
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(opaque);
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            ResponseFuture future = (ResponseFuture)this.responseTable.remove(opaque);
            if (null != future && future.getRequestCommand() != null) {
                this.collectLatencyStatistics(future.getRequestCommand().getCode(), future.elapsed(TimeUnit.MILLISECONDS));
            }
            if (responseFuture.getInvokeCallback() != null) {
                this.executeInvokeCallback(responseFuture);
            } else {
                responseFuture.putResponse(cmd);
                responseFuture.release();
            }
        } else {
            log.warn("receive response[opaque={}], but not matched any request, RemoteAddress={}", (Object)cmd.getOpaque(), (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            log.warn(cmd.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInvokeCallback(final ResponseFuture responseFuture) {
        boolean runInThisThread = false;
        ExecutorService executor = this.getCallbackExecutor();
        if (executor != null) {
            try {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            responseFuture.executeInvokeCallback();
                        }
                        catch (Throwable e) {
                            log.warn("execute callback in executor exception, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                    }
                });
            }
            catch (Exception e) {
                runInThisThread = true;
                log.warn("execute callback in executor exception, maybe executor busy", e);
            }
        } else {
            runInThisThread = true;
        }
        if (runInThisThread) {
            try {
                responseFuture.executeInvokeCallback();
            }
            catch (Throwable e) {
                log.warn("executeInvokeCallback Exception", e);
            }
            finally {
                responseFuture.release();
            }
        }
    }

    public abstract List<RPCHook> getRPCHook();

    public abstract ExecutorService getCallbackExecutor();

    public void scanResponseTable() {
        LinkedList<ResponseFuture> rfList = new LinkedList<ResponseFuture>();
        Iterator it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ResponseFuture rep = (ResponseFuture)next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            rep.release();
            it.remove();
            rfList.add(rep);
        }
        for (ResponseFuture rf : rfList) {
            try {
                this.executeInvokeCallback(rf);
            }
            catch (Throwable e) {
                log.warn("scanResponseTable, operationComplete Exception", e);
            }
        }
    }

    protected void collectLatencyStatistics(int code, long latency) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        final int opaque = request.getOpaque();
        if (!channel.isWritable() && QoS.DROP_ON_CONGESTION == request.getQos()) {
            log.info("Drop remoting command[code={}] as channel is not writable and QoS permits", (Object)request.getCode());
            return null;
        }
        try {
            final ResponseFuture responseFuture = new ResponseFuture(channel, opaque, request, timeoutMillis, null, null);
            this.responseTable.put(opaque, responseFuture);
            final String remoteAddress = RemotingHelper.parseSocketAddressAddr(channel.remoteAddress());
            channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture f) {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    NettyRemotingAbstract.this.responseTable.remove(opaque);
                    responseFuture.setCause(f.cause());
                    responseFuture.putResponse(null);
                    log.warn("send a request command to channel <" + remoteAddress + "> failed.");
                }
            });
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(remoteAddress, timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(remoteAddress, responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            ResponseFuture future = (ResponseFuture)this.responseTable.remove(opaque);
            if (null != future) {
                this.collectLatencyStatistics(future.getRequestCommand().getCode(), future.elapsed(TimeUnit.MILLISECONDS));
            }
        }
    }

    public void invokeAsyncImpl(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        boolean acquired;
        boolean drop = false;
        if (!channel.isWritable() && QoS.DROP_ON_CONGESTION == request.getQos()) {
            drop = true;
        }
        final int opaque = request.getOpaque();
        boolean bl = acquired = !drop && this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            final ResponseFuture responseFuture = new ResponseFuture(channel, opaque, request, timeoutMillis, invokeCallback, once);
            this.responseTable.put(opaque, responseFuture);
            try {
                final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
                channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) {
                        if (f.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        responseFuture.setSendRequestOK(false);
                        responseFuture.putResponse(null);
                        NettyRemotingAbstract.this.responseTable.remove(opaque);
                        try {
                            NettyRemotingAbstract.this.executeInvokeCallback(responseFuture);
                        }
                        catch (Throwable e) {
                            log.warn("execute callback in writeAndFlush addListener, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                        log.warn("send a request command to channel <{}> failed.", (Object)remoteAddress);
                    }
                });
            }
            catch (Exception e) {
                responseFuture.release();
                log.warn("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception", e);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (this instanceof NettyRemotingClient) {
                NettyRemotingClient nettyRemotingClient = (NettyRemotingClient)this;
                nettyRemotingClient.doAfterRpcFailure(request, channel, false);
            }
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    public void invokeOnewayImpl(final Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                if (!channel.isWritable()) {
                    once.release();
                    ReferenceCountUtil.release(request.getPayload());
                    log.info("Drop one-way request[code={}, opaque={}] as channel is not writable", (Object)request.getCode(), (Object)request.getOpaque());
                }
                channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) {
                        once.release();
                        if (!f.isSuccess()) {
                            log.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                log.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            ReferenceCountUtil.release(request.getPayload());
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String info = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreOneway.getQueueLength(), this.semaphoreOneway.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    static {
        NettyLogger.initNettyLogger();
    }

    class NettyEventExecutor
    extends ServiceThread {
        private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();

        NettyEventExecutor() {
        }

        public void putNettyEvent(NettyEvent event) {
            int maxSize = 10000;
            if (this.eventQueue.size() <= maxSize) {
                this.eventQueue.add(event);
            } else {
                log.warn("event queue size[{}] enough, so drop this event {}", (Object)this.eventQueue.size(), (Object)event.toString());
            }
        }

        @Override
        public void run() {
            log.info(this.getServiceName() + " service started");
            ChannelEventListener listener = NettyRemotingAbstract.this.getChannelEventListener();
            while (!this.isStopped()) {
                try {
                    NettyEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null || listener == null) continue;
                    switch (event.getType()) {
                        case IDLE: {
                            listener.onChannelIdle(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", e);
                }
            }
            log.info(this.getServiceName() + " service end");
        }

        @Override
        public String getServiceName() {
            return NettyEventExecutor.class.getSimpleName();
        }
    }
}

