/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private int markPosition;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (null == this.byteBuffer || !this.byteBuffer.hasRemaining()) {
            return -1;
        }
        int length = len;
        if (length > b.length - off) {
            length = b.length - off;
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, off, length);
        return length;
    }

    @Override
    public long skip(long n) throws IOException {
        if (null == this.byteBuffer || !this.byteBuffer.hasRemaining()) {
            return 0L;
        }
        long skipped = n;
        if (skipped > (long)this.byteBuffer.remaining()) {
            skipped = this.byteBuffer.remaining();
        }
        this.byteBuffer.position(this.byteBuffer.position() + (int)skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.remaining();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (null != this.byteBuffer) {
            this.markPosition = this.byteBuffer.position();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (null != this.byteBuffer) {
            this.byteBuffer.position(this.markPosition);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (null == this.byteBuffer || !this.byteBuffer.hasRemaining()) {
            return -1;
        }
        return this.byteBuffer.get();
    }
}

