/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.sasl.client;

import com.aliyun.openservices.ons.sasl.client.SaslUtil;
import com.aliyun.openservices.ons.sasl.client.ServiceAuthSigner;
import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class OnsSaslClient
implements SaslClient {
    public static final String ONS_MECHANISM = "ONS";
    private boolean completed = false;
    private String authorizationID;
    private String accessKey;
    private String secretKey;
    private String onsChannel = "ALIYUN";
    private final String VERSION = "0";
    private static byte SEP = 0;

    public OnsSaslClient(String authenticationID, String accessKey, String secretKey) throws SaslException {
        if (accessKey == null || secretKey == null) {
            throw new SaslException("ONS: AccessKey and SecretKey must be specified");
        }
        this.authorizationID = authenticationID;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Override
    public String getMechanismName() {
        return ONS_MECHANISM;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public void dispose() throws SaslException {
        this.clearPassword();
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        String[] tokens;
        if (this.completed) {
            throw new IllegalStateException("ONS authentication already completed");
        }
        if (challenge.length == 0) {
            this.completed = true;
            return null;
        }
        try {
            tokens = new String(challenge, "UTF-8").split("\u0000");
        }
        catch (UnsupportedEncodingException var6) {
            throw new SaslException("Cannot get UTF-8 encoding of ids", var6);
        }
        if (tokens.length < 2) {
            throw new SaslException("Invalid SASL/ONS chan: expected equal or more than 2 tokens, got " + tokens.length);
        }
        String timestamp = tokens[0];
        String randomNumber = tokens[1];
        byte[] data = SaslUtil.join(SEP, "0".getBytes(), this.accessKey.getBytes(), timestamp.getBytes(), randomNumber.getBytes(), String.valueOf((Object)ServiceAuthSigner.defaultAlgorithm).getBytes(), this.onsChannel.getBytes());
        String signaure = ServiceAuthSigner.calSignature(data, this.secretKey);
        byte[] response = SaslUtil.join(SEP, data, signaure.getBytes());
        return response;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            return propName.equals("javax.security.sasl.qop") ? "auth" : null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    private void clearPassword() {
        if (this.secretKey != null) {
            this.secretKey = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }
}

