/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class AsyncBatchGetRowCompletion
extends AsyncCompletion<BatchGetRowRequest, BatchGetRowResponse> {
    BatchGetRowRequest nextRequest;
    Map<String, PartialRowResult[]> tableToResults;
    List<String> requestIds;

    public AsyncBatchGetRowCompletion(OperationLauncher launcher, BatchGetRowRequest request, TraceLogger tracer, ExecutorService callbackExecutor, RetryStrategy retry, ScheduledExecutorService retryExecutor) {
        super(launcher, request, tracer, callbackExecutor, retry, retryExecutor);
    }

    @Override
    public void completed(BatchGetRowResponse result) {
        result.setTraceId(this.tracer.getTraceId());
        LogUtil.logOnCompleted(this.tracer, this.retry, result.getRequestId());
        this.tracer.printLog();
        if (this.isCompleted(result)) {
            if (this.nextRequest != null) {
                this.handleResult(result);
                this.onCompleted(this.request, this.buildFinalResult());
            } else {
                this.onCompleted(this.request, result);
            }
        } else {
            this.handleResult(result);
            this.sendNextRequest();
        }
    }

    boolean isCompleted(BatchGetRowResponse result) {
        for (BatchGetRowResponse.RowResult rowResult : result.getSucceedRows()) {
            if (!rowResult.hasNextToken()) continue;
            return false;
        }
        return true;
    }

    void handleConsumedCapacity(ConsumedCapacity base, ConsumedCapacity delta) {
        base.getCapacityUnit().setReadCapacityUnit(base.getCapacityUnit().getReadCapacityUnit() + delta.getCapacityUnit().getReadCapacityUnit());
        base.getCapacityUnit().setWriteCapacityUnit(base.getCapacityUnit().getWriteCapacityUnit() + delta.getCapacityUnit().getWriteCapacityUnit());
    }

    void handleResult(BatchGetRowResponse result) {
        if (this.tableToResults == null) {
            this.tableToResults = new ConcurrentHashMap<String, PartialRowResult[]>();
            for (Map.Entry<String, List<BatchGetRowResponse.RowResult>> entry : result.getTableToRowsResult().entrySet()) {
                PartialRowResult[] partialRowResults = new PartialRowResult[entry.getValue().size()];
                this.tableToResults.put(entry.getKey(), partialRowResults);
                int idx = 0;
                for (BatchGetRowResponse.RowResult rowResult : entry.getValue()) {
                    partialRowResults[idx] = new PartialRowResult();
                    if (rowResult.isSucceed()) {
                        partialRowResults[idx].consumedCapacity = rowResult.getConsumedCapacity();
                        if (rowResult.hasNextToken()) {
                            partialRowResults[idx].nextToken = rowResult.getNextToken();
                        }
                        if (rowResult.getRow() != null) {
                            partialRowResults[idx].primaryKey = rowResult.getRow().getPrimaryKey();
                            partialRowResults[idx].columns = new ArrayList<Column>(Arrays.asList(rowResult.getRow().getColumns()));
                        }
                    } else {
                        partialRowResults[idx].error = rowResult.getError();
                    }
                    ++idx;
                }
            }
        } else {
            for (Map.Entry<String, List<BatchGetRowResponse.RowResult>> entry : result.getTableToRowsResult().entrySet()) {
                PartialRowResult[] partialRowResults = this.tableToResults.get(entry.getKey());
                int idx = 0;
                for (BatchGetRowResponse.RowResult rowResult : entry.getValue()) {
                    while (partialRowResults[idx].isComplete()) {
                        ++idx;
                    }
                    if (rowResult.isSucceed()) {
                        this.handleConsumedCapacity(partialRowResults[idx].consumedCapacity, rowResult.getConsumedCapacity());
                        partialRowResults[idx].nextToken = (byte[])(rowResult.hasNextToken() ? rowResult.getNextToken() : null);
                        if (rowResult.getRow() != null) {
                            try {
                                if (partialRowResults[idx].primaryKey == null) {
                                    partialRowResults[idx].primaryKey = rowResult.getRow().getPrimaryKey();
                                    partialRowResults[idx].columns = new ArrayList<Column>();
                                }
                                partialRowResults[idx].columns.addAll(Arrays.asList(rowResult.getRow().getColumns()));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        partialRowResults[idx].error = rowResult.getError();
                    }
                    ++idx;
                }
            }
        }
        if (this.requestIds == null) {
            this.requestIds = new ArrayList<String>();
        }
        this.requestIds.add(result.getRequestId());
    }

    void buildNextRequest() {
        this.nextRequest = new BatchGetRowRequest();
        for (Map.Entry<String, PartialRowResult[]> entry : this.tableToResults.entrySet()) {
            String tableName = entry.getKey();
            PartialRowResult[] partialRowResults = entry.getValue();
            MultiRowQueryCriteria multiRowQueryCriteria = new MultiRowQueryCriteria(tableName);
            for (int i = 0; i < partialRowResults.length; ++i) {
                if (partialRowResults[i].isComplete()) continue;
                ((BatchGetRowRequest)this.request).getCriteria(tableName).copyTo(multiRowQueryCriteria);
                multiRowQueryCriteria.addRow(((BatchGetRowRequest)this.request).getPrimaryKey(tableName, i), partialRowResults[i].nextToken);
            }
            if (multiRowQueryCriteria.isEmpty()) continue;
            this.nextRequest.addMultiRowQueryCriteria(multiRowQueryCriteria);
        }
    }

    void sendNextRequest() {
        this.buildNextRequest();
        this.retry = this.retry.clone();
        this.launcher.fire(this.nextRequest, this);
    }

    BatchGetRowResponse buildFinalResult() {
        BatchGetRowResponse batchGetRowResponse = new BatchGetRowResponse(new Response(this.requestIds.get(0)));
        for (Map.Entry<String, PartialRowResult[]> entry : this.tableToResults.entrySet()) {
            String tableName = entry.getKey();
            PartialRowResult[] partialRowResults = entry.getValue();
            for (int i = 0; i < partialRowResults.length; ++i) {
                Preconditions.checkArgument(partialRowResults[i].isComplete());
                if (partialRowResults[i].error != null) {
                    BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(tableName, partialRowResults[i].error, i);
                    batchGetRowResponse.addResult(rowResult);
                    continue;
                }
                Row row = null;
                if (partialRowResults[i].primaryKey != null) {
                    row = new Row(partialRowResults[i].primaryKey, partialRowResults[i].columns);
                }
                BatchGetRowResponse.RowResult rowResult = new BatchGetRowResponse.RowResult(tableName, row, partialRowResults[i].consumedCapacity, i);
                batchGetRowResponse.addResult(rowResult);
            }
        }
        return batchGetRowResponse;
    }

    static class PartialRowResult {
        Error error;
        PrimaryKey primaryKey;
        List<Column> columns;
        ConsumedCapacity consumedCapacity;
        byte[] nextToken;

        PartialRowResult() {
        }

        boolean isComplete() {
            return this.error != null || this.nextToken == null;
        }
    }
}

