/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.utils;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Pair;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import java.util.Map;

public class ParamChecker {
    public static void checkRowChange(TableMeta tableMeta, RowChange rowChange, WriterConfig config) throws ClientException {
        if (!tableMeta.getTableName().equals(rowChange.getTableName())) {
            throw new ClientException("The row to write belongs to another table.");
        }
        if (rowChange.getDataSize() > config.getMaxBatchSize()) {
            throw new ClientException("The row size exceeds the max batch size: " + config.getMaxBatchSize() + ".");
        }
        Map<String, PrimaryKeySchema> pkDefinedInMeta = tableMeta.getPrimaryKeySchemaMap();
        Map<String, PrimaryKeyColumn> pkInRow = rowChange.getPrimaryKey().getPrimaryKeyColumnsMap();
        if (pkDefinedInMeta.size() != pkInRow.size()) {
            throw new ClientException("The primary key schema is not match which defined in table meta.");
        }
        for (Map.Entry<String, PrimaryKeySchema> entry : pkDefinedInMeta.entrySet()) {
            PrimaryKeyValue value = pkInRow.get(entry.getKey()).getValue();
            if (value == null) {
                throw new ClientException("Can't find primary key column '" + entry.getKey() + "' in row.");
            }
            if (value.isPlaceHolderForAutoIncr()) {
                if (entry.getValue().getOption() != PrimaryKeyOption.AUTO_INCREMENT) {
                    throw new ClientException("The type of primary key column '" + entry.getKey() + "' should not be AUTO_INCREMENT.");
                }
            } else if (value.getType() != entry.getValue().getType()) {
                throw new ClientException("The type of primary key column '" + entry.getKey() + "' is " + (Object)((Object)value.getType()) + ", but it's defined as " + (Object)((Object)entry.getValue().getType()) + " in table meta.");
            }
            if (value.getDataSize() <= config.getMaxPKColumnSize()) continue;
            throw new ClientException("The size of primary key column '" + entry.getKey() + "' has exceeded the max length:" + config.getMaxPKColumnSize() + ".");
        }
        int columnsCount = 0;
        if (rowChange instanceof RowPutChange) {
            RowPutChange rowPut = (RowPutChange)rowChange;
            columnsCount = rowPut.getColumnsToPut().size();
            for (Column column : rowPut.getColumnsToPut()) {
                ParamChecker.checkColumn(pkDefinedInMeta, column, config);
            }
        } else if (rowChange instanceof RowUpdateChange) {
            RowUpdateChange rowUpdate = (RowUpdateChange)rowChange;
            columnsCount = rowUpdate.getColumnsToUpdate().size();
            for (Pair pair : rowUpdate.getColumnsToUpdate()) {
                ParamChecker.checkColumn(pkDefinedInMeta, (Column)pair.first, config);
            }
        }
        if (columnsCount > config.getMaxColumnsCount()) {
            throw new ClientException("The count of attribute columns exceeds the maximum: " + config.getMaxColumnsCount() + ".");
        }
    }

    public static void checkColumn(Map<String, PrimaryKeySchema> pkDefinedInMeta, Column column, WriterConfig config) {
        if (pkDefinedInMeta.containsKey(column.getName())) {
            throw new ClientException("The attribute column's name duplicate with primary key column, which is '" + column.getName() + "'.");
        }
        ColumnValue value = column.getValue();
        if (value != null && value.getDataSize() > config.getMaxAttrColumnSize()) {
            throw new ClientException("The size of attribute column '" + column.getName() + "' has exceeded the max length: " + config.getMaxAttrColumnSize() + ".");
        }
    }
}

