/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

public class ComputeParameters {
    private int maxSplitsCount;
    private long splitSizeInMBs;
    private ComputeMode computeMode;
    private String searchIndexName;

    public ComputeParameters(int maxSplitsCount, long splitSizeInMBs, ComputeMode computeMode) {
        this.maxSplitsCount = maxSplitsCount;
        this.splitSizeInMBs = splitSizeInMBs;
        this.computeMode = computeMode;
    }

    public ComputeParameters(String searchIndexName, int maxSplitsCount) {
        this.computeMode = ComputeMode.Search;
        this.searchIndexName = searchIndexName;
        this.maxSplitsCount = maxSplitsCount;
    }

    public ComputeParameters() {
        this.computeMode = ComputeMode.KV;
        this.maxSplitsCount = 1000;
        this.splitSizeInMBs = 10L;
    }

    public int getMaxSplitsCount() {
        return this.maxSplitsCount;
    }

    public long getSplitSizeInMBs() {
        return this.splitSizeInMBs;
    }

    public ComputeMode getComputeMode() {
        return this.computeMode;
    }

    public String getSearchIndexName() {
        return this.searchIndexName;
    }

    public void setComputeMode(ComputeMode computeMode) {
        this.computeMode = computeMode;
    }

    public static enum ComputeMode {
        Auto,
        KV,
        Search;

    }
}

