/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import java.util.List;

public class Filter {
    private LogicOperator logicOperator;
    private CompareOperator compareOperator;
    private List<Filter> filters;
    private String columnName;
    private ColumnValue columnValue;
    private List<ColumnValue> columnValuesForInOperator;

    public boolean isNested() {
        return this.filters != null && this.filters.size() > 0;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public List<Filter> getSubFilters() {
        return this.filters;
    }

    public LogicOperator getLogicOperator() {
        return this.logicOperator;
    }

    public CompareOperator getCompareOperator() {
        return this.compareOperator;
    }

    public Filter(LogicOperator lo, List<Filter> subFilters) {
        this.logicOperator = lo;
        this.filters = subFilters;
    }

    public Filter(CompareOperator compareOperator, String columnName) {
        this.compareOperator = compareOperator;
        this.columnName = columnName;
    }

    public Filter(CompareOperator co, String columnName, ColumnValue columnValue) {
        this.compareOperator = co;
        this.columnName = columnName;
        this.columnValue = columnValue;
    }

    public Filter(CompareOperator co, String columnName, List<ColumnValue> columnValuesForInOperator) {
        this.compareOperator = co;
        this.columnName = columnName;
        this.columnValuesForInOperator = columnValuesForInOperator;
    }

    public Filter(CompareOperator co) {
        this.compareOperator = co;
    }

    public static Filter emptyFilter() {
        return new Filter(CompareOperator.EMPTY_FILTER);
    }

    public void setLogicOperator(LogicOperator logicOperator) {
        this.logicOperator = logicOperator;
    }

    public void setCompareOperator(CompareOperator compareOperator) {
        this.compareOperator = compareOperator;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnValue(ColumnValue columnValue) {
        this.columnValue = columnValue;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<ColumnValue> getColumnValuesForInOperator() {
        return this.columnValuesForInOperator;
    }

    public void setColumnValuesForInOperator(List<ColumnValue> columnValuesForInOperator) {
        this.columnValuesForInOperator = columnValuesForInOperator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        if (this.logicOperator != filter.logicOperator) {
            return false;
        }
        if (this.compareOperator != filter.compareOperator) {
            return false;
        }
        if (this.filters != null ? !this.filters.equals(filter.filters) : filter.filters != null) {
            return false;
        }
        if (this.columnName != null ? !this.columnName.equals(filter.columnName) : filter.columnName != null) {
            return false;
        }
        if (this.columnValue != null ? !this.columnValue.equals(filter.columnValue) : filter.columnValue != null) {
            return false;
        }
        return this.columnValuesForInOperator != null ? this.columnValuesForInOperator.equals(filter.columnValuesForInOperator) : filter.columnValuesForInOperator == null;
    }

    public int hashCode() {
        int result = this.logicOperator != null ? this.logicOperator.hashCode() : 0;
        result = 31 * result + (this.compareOperator != null ? this.compareOperator.hashCode() : 0);
        result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + (this.columnName != null ? this.columnName.hashCode() : 0);
        result = 31 * result + (this.columnValue != null ? this.columnValue.hashCode() : 0);
        result = 31 * result + (this.columnValuesForInOperator != null ? this.columnValuesForInOperator.hashCode() : 0);
        return result;
    }

    public static enum LogicOperator {
        NOT,
        AND,
        OR;

    }

    public static enum CompareOperator {
        EMPTY_FILTER,
        EQUAL,
        GREATER_EQUAL,
        GREATER_THAN,
        LESS_EQUAL,
        LESS_THAN,
        NOT_EQUAL,
        START_WITH,
        IN,
        IS_NULL;

    }
}

