/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Request;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRowRequest
implements Request {
    private Map<String, MultiRowQueryCriteria> criteriasGroupByTable = new HashMap<String, MultiRowQueryCriteria>();

    @Override
    public String getOperationName() {
        return "BatchGetRow";
    }

    public void addMultiRowQueryCriteria(MultiRowQueryCriteria criteria) {
        Preconditions.checkArgument(criteria != null && !criteria.isEmpty(), "The query criteria for table should not be null or empty.");
        String tableName = criteria.getTableName();
        this.criteriasGroupByTable.put(tableName, criteria);
    }

    public PrimaryKey getPrimaryKey(String tableName, int index) {
        MultiRowQueryCriteria criteria = this.criteriasGroupByTable.get(tableName);
        if (criteria == null) {
            return null;
        }
        if (index >= criteria.getRowKeys().size()) {
            return null;
        }
        return criteria.getRowKeys().get(index);
    }

    public Map<String, MultiRowQueryCriteria> getCriteriasByTable() {
        return this.criteriasGroupByTable;
    }

    public MultiRowQueryCriteria getCriteria(String tableName) {
        return this.criteriasGroupByTable.get(tableName);
    }

    public BatchGetRowRequest createRequestForRetry(List<BatchGetRowResponse.RowResult> failedRows) {
        BatchGetRowRequest request = new BatchGetRowRequest();
        for (BatchGetRowResponse.RowResult rowResult : failedRows) {
            PrimaryKey primaryKey = this.getPrimaryKey(rowResult.getTableName(), rowResult.getIndex());
            if (primaryKey == null) {
                throw new IllegalArgumentException("Can not find table '" + rowResult.getTableName() + "' with index " + rowResult.getIndex());
            }
            MultiRowQueryCriteria newCriteria = request.getCriteria(rowResult.getTableName());
            if (newCriteria == null) {
                MultiRowQueryCriteria oldCriteria = this.getCriteria(rowResult.getTableName());
                if (oldCriteria == null) {
                    throw new IllegalArgumentException("Can not found query criteria for table '" + rowResult.getTableName() + "'.");
                }
                newCriteria = oldCriteria.cloneWithoutRowKeys();
                newCriteria.addRow(primaryKey);
                request.addMultiRowQueryCriteria(newCriteria);
                continue;
            }
            newCriteria.addRow(primaryKey);
        }
        return request;
    }

    public boolean isEmpty() {
        return this.criteriasGroupByTable.isEmpty();
    }
}

