/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class CapacityUnit
implements Jsonizable {
    private OptionalValue<Integer> readCapacityUnit = new OptionalValue("ReadCapacityUnit");
    private OptionalValue<Integer> writeCapacityUnit = new OptionalValue("WriteCapacityUnit");

    public CapacityUnit() {
    }

    public CapacityUnit(int readCapacityUnit, int writeCapacityUnit) {
        this.setReadCapacityUnit(readCapacityUnit);
        this.setWriteCapacityUnit(writeCapacityUnit);
    }

    public int getReadCapacityUnit() {
        if (!this.readCapacityUnit.isValueSet()) {
            throw new IllegalStateException("The value of read capacity unit is not set.");
        }
        return this.readCapacityUnit.getValue();
    }

    public void setReadCapacityUnit(int readCapacityUnit) {
        Preconditions.checkArgument(readCapacityUnit >= 0, "The value of read capacity unit can't be negative.");
        this.readCapacityUnit.setValue(readCapacityUnit);
    }

    public boolean hasSetReadCapacityUnit() {
        return this.readCapacityUnit.isValueSet();
    }

    public void clearReadCapacityUnit() {
        this.readCapacityUnit.clear();
    }

    public int getWriteCapacityUnit() {
        if (!this.writeCapacityUnit.isValueSet()) {
            throw new IllegalStateException("The value of write capacity unit is not set.");
        }
        return this.writeCapacityUnit.getValue();
    }

    public void setWriteCapacityUnit(int writeCapacityUnit) {
        Preconditions.checkArgument(writeCapacityUnit >= 0, "The value of write capacity unit can't be negative.");
        this.writeCapacityUnit.setValue(writeCapacityUnit);
    }

    public boolean hasSetWriteCapacityUnit() {
        return this.writeCapacityUnit.isValueSet();
    }

    public void clearWriteCapacityUnit() {
        this.writeCapacityUnit.clear();
    }

    public int hashCode() {
        return this.readCapacityUnit.hashCode() ^ this.writeCapacityUnit.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CapacityUnit)) {
            return false;
        }
        CapacityUnit c1 = (CapacityUnit)o;
        return this.readCapacityUnit.equals(c1.readCapacityUnit) && this.writeCapacityUnit.equals(c1.writeCapacityUnit);
    }

    public String toString() {
        return "" + this.readCapacityUnit + ", " + this.writeCapacityUnit;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        boolean firstItem = true;
        sb.append('{');
        if (this.readCapacityUnit.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"Read\": ");
            sb.append(this.readCapacityUnit.getValue());
        }
        if (this.writeCapacityUnit.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"Write\": ");
            sb.append(this.writeCapacityUnit.getValue());
        }
        sb.append('}');
    }
}

