/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;

public class GetStreamRecordRequest
implements Request {
    private String shardIterator;
    private OptionalValue<Integer> limit = new OptionalValue("Limit");

    public GetStreamRecordRequest(String shardIterator) {
        this.setShardIterator(shardIterator);
    }

    public void setShardIterator(String shardIterator) {
        Preconditions.checkArgument(shardIterator != null && !shardIterator.isEmpty(), "The shard iterator is null or empty.");
        this.shardIterator = shardIterator;
    }

    public String getShardIterator() {
        return this.shardIterator;
    }

    public int getLimit() {
        if (this.limit.isValueSet()) {
            return this.limit.getValue();
        }
        return -1;
    }

    public void setLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "The limit must be greater than 0.");
        this.limit.setValue(limit);
    }

    @Override
    public String getOperationName() {
        return "GetStreamRecord";
    }
}

