/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.RowQueryCriteria;

public class RangeIteratorParameter
extends RowQueryCriteria {
    private Direction direction = Direction.FORWARD;
    private int maxCount = -1;
    private int bufferSize = -1;
    private PrimaryKey inclusiveStartPrimaryKey;
    private PrimaryKey exclusiveEndPrimaryKey;

    public RangeIteratorParameter(String tableName) {
        super(tableName);
    }

    public RangeIteratorParameter(RangeRowQueryCriteria criteria) {
        super(criteria.getTableName());
        criteria.copyTo(this);
        this.direction = criteria.getDirection();
        this.bufferSize = criteria.getLimit();
        this.inclusiveStartPrimaryKey = criteria.getInclusiveStartPrimaryKey();
        this.exclusiveEndPrimaryKey = criteria.getExclusiveEndPrimaryKey();
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        Preconditions.checkArgument(maxCount > 0, "The max count must be greater than 0.");
        this.maxCount = maxCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize > 0, "The buffer size must be greater than 0.");
        this.bufferSize = bufferSize;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        Preconditions.checkNotNull(direction, "The direction should not be null.");
        this.direction = direction;
    }

    public PrimaryKey getInclusiveStartPrimaryKey() {
        return this.inclusiveStartPrimaryKey;
    }

    public void setInclusiveStartPrimaryKey(PrimaryKey inclusiveStartPrimaryKey) {
        Preconditions.checkArgument(inclusiveStartPrimaryKey != null && !inclusiveStartPrimaryKey.isEmpty(), "The start primary key should not be null or empty.");
        this.inclusiveStartPrimaryKey = inclusiveStartPrimaryKey;
    }

    public PrimaryKey getExclusiveEndPrimaryKey() {
        return this.exclusiveEndPrimaryKey;
    }

    public void setExclusiveEndPrimaryKey(PrimaryKey exclusiveEndPrimaryKey) {
        Preconditions.checkArgument(exclusiveEndPrimaryKey != null && !exclusiveEndPrimaryKey.isEmpty(), "The end primary key should not be null or empty.");
        this.exclusiveEndPrimaryKey = exclusiveEndPrimaryKey;
    }
}

