/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.tunnel;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.tunnel.StreamTunnelConfig;
import com.alicloud.openservices.tablestore.model.tunnel.TunnelType;

public class CreateTunnelRequest
implements Request {
    private String tableName;
    private String tunnelName;
    private TunnelType tunnelType;
    private StreamTunnelConfig streamTunnelConfig;

    public CreateTunnelRequest(String tableName, String tunnelName, TunnelType tunnelType) {
        this.setTableName(tableName);
        this.setTunnelName(tunnelName);
        this.setTunnelType(tunnelType);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name should not be empty.");
        this.tableName = tableName;
    }

    public String getTunnelName() {
        return this.tunnelName;
    }

    public void setTunnelName(String tunnelName) {
        Preconditions.checkArgument(tunnelName != null && !tunnelName.isEmpty(), "The tunnel name should not be empty.");
        this.tunnelName = tunnelName;
    }

    public TunnelType getTunnelType() {
        return this.tunnelType;
    }

    public void setTunnelType(TunnelType tunnelType) {
        Preconditions.checkArgument(tunnelType != null, "The tunnel type should not be null.");
        this.tunnelType = tunnelType;
    }

    @Override
    public String getOperationName() {
        return "tunnel/create";
    }

    public StreamTunnelConfig getStreamTunnelConfig() {
        return this.streamTunnelConfig;
    }

    public void setStreamTunnelConfig(StreamTunnelConfig streamTunnelConfig) {
        this.streamTunnelConfig = streamTunnelConfig;
    }
}

