/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.client;

import com.aliyun.ots.thirdparty.org.apache.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.annotation.ThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.client.ClientProtocolException;
import com.aliyun.ots.thirdparty.org.apache.client.HttpClient;
import com.aliyun.ots.thirdparty.org.apache.client.ResponseHandler;
import com.aliyun.ots.thirdparty.org.apache.client.methods.CloseableHttpResponse;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpUriRequest;
import com.aliyun.ots.thirdparty.org.apache.client.utils.URIUtils;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import com.aliyun.ots.thirdparty.org.apache.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CloseableHttpClient
implements HttpClient,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.doExecute(target, request, context);
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(request, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request), request, context);
    }

    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, (HttpContext)null);
    }

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.doExecute(target, request, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        HttpHost target = CloseableHttpClient.determineTarget(request);
        return this.execute(target, request, responseHandler, context);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        T result;
        Args.notNull(responseHandler, "Response handler");
        CloseableHttpResponse response = this.execute(target, request, context);
        try {
            result = responseHandler.handleResponse(response);
        }
        catch (Exception t) {
            HttpEntity entity = response.getEntity();
            try {
                EntityUtils.consume(entity);
            }
            catch (Exception t2) {
                this.log.warn((Object)"Error consuming content after an exception.", (Throwable)t2);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        HttpEntity entity = response.getEntity();
        EntityUtils.consume(entity);
        return result;
    }
}

