/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.cookie;

import com.aliyun.ots.thirdparty.org.apache.Header;
import com.aliyun.ots.thirdparty.org.apache.HeaderElement;
import com.aliyun.ots.thirdparty.org.apache.NameValuePair;
import com.aliyun.ots.thirdparty.org.apache.annotation.NotThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.cookie.ClientCookie;
import com.aliyun.ots.thirdparty.org.apache.cookie.Cookie;
import com.aliyun.ots.thirdparty.org.apache.cookie.CookieAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.cookie.CookieOrigin;
import com.aliyun.ots.thirdparty.org.apache.cookie.MalformedCookieException;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.BasicClientCookie2;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2109Spec;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2965DiscardAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2965DomainAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2965PortAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.impl.cookie.RFC2965VersionAttributeHandler;
import com.aliyun.ots.thirdparty.org.apache.message.BufferedHeader;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import com.aliyun.ots.thirdparty.org.apache.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] datepatterns, boolean oneHeader) {
        super(datepatterns, oneHeader);
        this.registerAttribHandler("domain", new RFC2965DomainAttributeHandler());
        this.registerAttribHandler("port", new RFC2965PortAttributeHandler());
        this.registerAttribHandler("commenturl", new RFC2965CommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new RFC2965DiscardAttributeHandler());
        this.registerAttribHandler("version", new RFC2965VersionAttributeHandler());
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] elems = header.getElements();
        return this.createCookies(elems, RFC2965Spec.adjustEffectiveHost(origin));
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        return this.createCookies(elems, RFC2965Spec.adjustEffectiveHost(origin));
    }

    private List<Cookie> createCookies(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 cookie = new BasicClientCookie2(name, value);
            cookie.setPath(RFC2965Spec.getDefaultPath(origin));
            cookie.setDomain(RFC2965Spec.getDefaultDomain(origin));
            cookie.setPorts(new int[]{origin.getPort()});
            NameValuePair[] attribs = headerelement.getParameters();
            HashMap<String, NameValuePair> attribmap = new HashMap<String, NameValuePair>(attribs.length);
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair param = attribs[j];
                attribmap.put(param.getName().toLowerCase(Locale.ENGLISH), param);
            }
            for (Map.Entry entry : attribmap.entrySet()) {
                NameValuePair attrib = (NameValuePair)entry.getValue();
                String s2 = attrib.getName().toLowerCase(Locale.ENGLISH);
                cookie.setAttribute(s2, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s2);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        super.validate(cookie, RFC2965Spec.adjustEffectiveHost(origin));
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return super.match(cookie, RFC2965Spec.adjustEffectiveHost(origin));
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version) {
        String s2;
        super.formatCookieAsVer(buffer, cookie, version);
        if (cookie instanceof ClientCookie && (s2 = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] ports;
            buffer.append("; $Port");
            buffer.append("=\"");
            if (s2.trim().length() > 0 && (ports = cookie.getPorts()) != null) {
                int len = ports.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(Integer.toString(ports[i]));
                }
            }
            buffer.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin origin) {
        String host = origin.getHost();
        boolean isLocalHost = true;
        for (int i = 0; i < host.length(); ++i) {
            char ch = host.charAt(i);
            if (ch != '.' && ch != ':') continue;
            isLocalHost = false;
            break;
        }
        if (isLocalHost) {
            host = host + ".local";
            return new CookieOrigin(host, origin.getPort(), origin.getPath(), origin.isSecure());
        }
        return origin;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer buffer = new CharArrayBuffer(40);
        buffer.append("Cookie2");
        buffer.append(": ");
        buffer.append("$Version=");
        buffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(buffer);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

