/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.conn.ssl;

import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.conn.ssl.AllowAllHostnameVerifier;
import com.aliyun.ots.thirdparty.org.apache.conn.ssl.BrowserCompatHostnameVerifier;
import com.aliyun.ots.thirdparty.org.apache.conn.ssl.SSLContexts;
import com.aliyun.ots.thirdparty.org.apache.conn.ssl.StrictHostnameVerifier;
import com.aliyun.ots.thirdparty.org.apache.conn.ssl.X509HostnameVerifier;
import com.aliyun.ots.thirdparty.org.apache.nio.conn.SchemeIOSessionStrategy;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.IOSession;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.ssl.SSLIOSession;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.ssl.SSLMode;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.ssl.SSLSetupHandler;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import com.aliyun.ots.thirdparty.org.apache.util.Asserts;
import com.aliyun.ots.thirdparty.org.apache.util.TextUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLIOSessionStrategy
implements SchemeIOSessionStrategy {
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final X509HostnameVerifier hostnameVerifier;

    private static String[] split(String s2) {
        if (TextUtils.isBlank(s2)) {
            return null;
        }
        return s2.split(" *, *");
    }

    public static SSLIOSessionStrategy getDefaultStrategy() {
        return new SSLIOSessionStrategy(SSLContexts.createDefault(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public static SSLIOSessionStrategy getSystemDefaultStrategy() {
        return new SSLIOSessionStrategy(SSLContexts.createSystemDefault(), SSLIOSessionStrategy.split(System.getProperty("https.protocols")), SSLIOSessionStrategy.split(System.getProperty("https.cipherSuites")), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLIOSessionStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }

    public SSLIOSessionStrategy(SSLContext sslcontext, X509HostnameVerifier hostnameVerifier) {
        this(sslcontext, null, null, hostnameVerifier);
    }

    public SSLIOSessionStrategy(SSLContext sslcontext) {
        this(sslcontext, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLIOSession upgrade(final HttpHost host, IOSession iosession) throws IOException {
        Asserts.check(!(iosession instanceof SSLIOSession), "I/O session is already upgraded to TLS/SSL");
        SSLIOSession ssliosession = new SSLIOSession(iosession, SSLMode.CLIENT, this.sslContext, new SSLSetupHandler(){

            public void initalize(SSLEngine sslengine) throws SSLException {
                if (SSLIOSessionStrategy.this.supportedProtocols != null) {
                    sslengine.setEnabledProtocols(SSLIOSessionStrategy.this.supportedProtocols);
                }
                if (SSLIOSessionStrategy.this.supportedCipherSuites != null) {
                    sslengine.setEnabledCipherSuites(SSLIOSessionStrategy.this.supportedCipherSuites);
                }
                SSLIOSessionStrategy.this.initializeEngine(sslengine);
            }

            public void verify(IOSession iosession, SSLSession sslsession) throws SSLException {
                SSLIOSessionStrategy.this.verifySession(host, iosession, sslsession);
            }
        });
        iosession.setAttribute("http.session.ssl", ssliosession);
        ssliosession.initialize();
        return ssliosession;
    }

    protected void initializeEngine(SSLEngine engine) {
    }

    protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
        Certificate[] certs = sslsession.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certs[0];
        this.hostnameVerifier.verify(host.getHostName(), x509);
    }

    public boolean isLayeringRequired() {
        return true;
    }
}

