/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.common.utils.VersionInfoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClientConfiguration {
    private static final String DEFAULT_USER_AGENT = VersionInfoUtils.getDefaultUserAgent();
    private static final int DEFAULT_MAX_RETRIES = 3;
    private String userAgent = DEFAULT_USER_AGENT;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private int maxConnections = 512;
    private int socketTimeout = 50000;
    private int connectionTimeout = 50000;
    private int maxErrorRetry = 3;
    private static final String DEFAULT_CNAME_EXCLUDE_LIST = ".aliyuncs.com,.aliyun-inc.com,localhost";
    private List<String> cnameExcludeList = new ArrayList<String>();
    private Lock rlock = new ReentrantLock();

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) throws ClientException {
        if (proxyPort <= 0) {
            throw new ClientException(ResourceManager.getInstance("common").getString("ParameterIsInvalid"), null);
        }
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public List<String> getCnameExcludeList() {
        if (this.cnameExcludeList.size() == 0) {
            this.rlock.lock();
            if (this.cnameExcludeList.size() == 0) {
                ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
            }
            this.rlock.unlock();
        }
        return Collections.unmodifiableList(this.cnameExcludeList);
    }

    public void setCnameExcludeList(List<String> cnameExcludeList) {
        if (cnameExcludeList == null) {
            throw new NullPointerException("cnameExcludeList to be set should not be null.");
        }
        this.cnameExcludeList.clear();
        for (String excl : cnameExcludeList) {
            if (excl.trim().isEmpty()) continue;
            this.cnameExcludeList.add(excl);
        }
        ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
    }

    private static void AppendDefaultExcludeList(List<String> excludeList) {
        String[] excludes;
        for (String excl : excludes = DEFAULT_CNAME_EXCLUDE_LIST.split(",")) {
            if (excl.trim().isEmpty() || excludeList.contains(excl)) continue;
            excludeList.add(excl.trim().toLowerCase());
        }
    }
}

