/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.auth.ServiceCredentials;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.internal.OSSErrorResponseHandler;
import com.aliyun.oss.internal.OSSRequestSigner;
import com.aliyun.oss.internal.OSSUtils;
import java.net.URI;

public abstract class OSSOperation {
    private URI endpoint;
    private ServiceCredentials credentials;
    private ServiceClient client;

    protected OSSOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        assert (endpoint != null && client != null && cred != null);
        this.endpoint = endpoint;
        this.client = client;
        this.credentials = cred;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    protected ServiceClient getInnerClient() {
        return this.client;
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context) throws OSSException, ClientException {
        return this.send(request, context, false);
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws OSSException, ClientException {
        try {
            ResponseMessage response = this.client.sendRequest(request, context);
            if (!keepResponseOpen) {
                OSSUtils.safeCloseResponse(response);
            }
            return response;
        }
        catch (ServiceException e) {
            assert (e instanceof OSSException);
            throw (OSSException)e;
        }
    }

    private static RequestSigner createSigner(HttpMethod method, String bucket, String key, ServiceCredentials credentials) {
        String resourcePath = "/" + (bucket != null ? bucket : "") + (key != null ? "/" + key : "");
        if (bucket != null && key == null) {
            resourcePath = resourcePath + "/";
        }
        return new OSSRequestSigner(method.toString(), resourcePath, credentials);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucket, String key) {
        ExecutionContext context = new ExecutionContext();
        context.setCharset("utf-8");
        context.setSigner(OSSOperation.createSigner(method, bucket, key, this.credentials));
        context.getResponseHandlers().add(new OSSErrorResponseHandler());
        if (method == HttpMethod.POST) {
            context.setRetryStrategy(new RetryStrategy(){

                @Override
                public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
                    return false;
                }
            });
        }
        return context;
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName) {
        return this.createDefaultContext(method, bucketName, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method) {
        return this.createDefaultContext(method, null, null);
    }
}

