/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OSSUtils {
    private static String BUCKET_NAMING_REGEX = "^[a-z0-9][a-z0-9_\\-]{1,61}[a-z0-9]$";
    public static final ResourceManager OSS_RESOURCE_MANAGER = ResourceManager.getInstance("oss");

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        return bucketName.matches(BUCKET_NAMING_REGEX);
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!OSSUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException(OSS_RESOURCE_MANAGER.getFormattedString("BucketNameInvalid", bucketName));
        }
    }

    public static boolean validateObjectKey(String key) {
        byte[] bytes;
        if (key == null) {
            return false;
        }
        try {
            bytes = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = key.toCharArray();
        char beginKeyChar = keyChars[0];
        if (beginKeyChar == '/' || beginKeyChar == '\\') {
            return false;
        }
        return bytes.length > 0 && bytes.length < 1024;
    }

    public static void ensureObjectKeyValid(String key) {
        if (!OSSUtils.validateObjectKey(key)) {
            throw new IllegalArgumentException(OSS_RESOURCE_MANAGER.getFormattedString("ObjectKeyInvalid", key));
        }
    }

    public static URI determineFinalEndpoint(URI endpoint, String bucket, ClientConfiguration clientConfig) {
        try {
            StringBuilder conbinedEndpoint = new StringBuilder();
            conbinedEndpoint.append(String.format("%s://", endpoint.getScheme()));
            conbinedEndpoint.append(OSSUtils.buildCanonicalHost(endpoint, bucket, clientConfig));
            conbinedEndpoint.append(endpoint.getPort() != -1 ? String.format(":%s", endpoint.getPort()) : "");
            conbinedEndpoint.append(endpoint.getPath());
            return new URI(conbinedEndpoint.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private static String buildCanonicalHost(URI endpoint, String bucket, ClientConfiguration clientConfig) {
        String host = endpoint.getHost();
        boolean isCname = OSSUtils.cnameExcludeFilter(host, clientConfig.getCnameExcludeList());
        StringBuffer cannonicalHost = new StringBuffer();
        if (bucket != null && !isCname) {
            cannonicalHost.append(bucket);
            cannonicalHost.append(".");
            cannonicalHost.append(host);
        } else {
            cannonicalHost.append(host);
        }
        return cannonicalHost.toString();
    }

    private static boolean cnameExcludeFilter(String hostToFilter, List<String> excludeList) {
        if (hostToFilter != null && !hostToFilter.trim().isEmpty()) {
            String canonicalHost = hostToFilter.toLowerCase();
            for (String excl : excludeList) {
                if (!canonicalHost.endsWith(excl)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Host name can not be null.");
    }

    public static String makeResourcePath(String key) {
        return key != null ? OSSUtils.urlEncodeKey(key) : null;
    }

    public static String makeResourcePath(String bucket, String key) {
        if (bucket != null) {
            return bucket + (key != null ? "/" + OSSUtils.urlEncodeKey(key) : "");
        }
        return null;
    }

    private static String urlEncodeKey(String key) {
        int i;
        StringBuffer resultUri = new StringBuffer();
        String[] keys = key.split("/");
        resultUri.append(HttpUtil.urlEncode(keys[0], "utf-8"));
        for (i = 1; i < keys.length; ++i) {
            resultUri.append("/").append(HttpUtil.urlEncode(keys[i], "utf-8"));
        }
        if (key.endsWith("/")) {
            for (i = key.length() - 1; i >= 0 && key.charAt(i) == '/'; --i) {
                resultUri.append("/");
            }
        }
        return resultUri.toString();
    }

    public static void populateRequestMetadata(Map<String, String> headers, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                headers.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                headers.put("x-oss-meta-" + key, value);
            }
        }
    }

    public static void addHeader(Map<String, String> headers, String header, String value) {
        if (value != null) {
            headers.put(header, value);
        }
    }

    public static void addDateHeader(Map<String, String> headers, String header, Date value) {
        if (value != null) {
            headers.put(header, DateUtil.formatRfc822Date(value));
        }
    }

    public static void addStringListHeader(Map<String, String> headers, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            headers.put(header, OSSUtils.join(values));
        }
    }

    public static void removeHeader(Map<String, String> headers, String header) {
        if (header != null && headers.containsKey(header)) {
            headers.remove(header);
        }
    }

    public static String join(List<String> strings) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result.append(", ");
            }
            result.append(s);
            first = false;
        }
        return result.toString();
    }

    public static String trimQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void populateResponseHeaderParameters(Map<String, String> params, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                params.put("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                params.put("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                params.put("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLangauge() != null) {
                params.put("response-content-language", responseHeaders.getContentLangauge());
            }
            if (responseHeaders.getContentType() != null) {
                params.put("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                params.put("response-expires", responseHeaders.getExpires());
            }
        }
    }

    public static void safeCloseResponse(ResponseMessage response) {
        try {
            response.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long determineInputStreamLength(InputStream instream, long hintLength) {
        if (hintLength <= 0L || !instream.markSupported()) {
            return -1L;
        }
        return hintLength;
    }

    public static long determineInputStreamLength(InputStream instream, long hintLength, boolean useChunkEncoding) {
        if (useChunkEncoding) {
            return -1L;
        }
        if (hintLength <= 0L || !instream.markSupported()) {
            return -1L;
        }
        return hintLength;
    }

    public static String joinETags(List<String> etags) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String etag : etags) {
            if (!first) {
                result.append(", ");
            }
            result.append(etag);
            first = false;
        }
        return result.toString();
    }
}

