/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.model.SetBucketCORSRequest;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class BucketCORSTest
extends TestBase {
    private static int MAX_CORS_RULE_LIMIT = 10;

    @Test
    public void testNormalSetBucketCORS() {
        String bucketName = "normal-set-bucket-cors";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-cors");
                SetBucketCORSRequest request = new SetBucketCORSRequest("normal-set-bucket-cors");
                SetBucketCORSRequest.CORSRule r0 = new SetBucketCORSRequest.CORSRule();
                r0.addAllowdOrigin("http://www.a.com");
                r0.addAllowdOrigin("http://www.b.com");
                r0.addAllowedMethod("GET");
                r0.addAllowedHeader("Authorization");
                r0.addExposeHeader("x-oss-test");
                r0.addExposeHeader("x-oss-test1");
                r0.setMaxAgeSeconds(100);
                request.addCorsRule(r0);
                secondClient.setBucketCORS(request);
                List<SetBucketCORSRequest.CORSRule> rules = secondClient.getBucketCORSRules("normal-set-bucket-cors");
                r0 = rules.get(0);
                Assert.assertEquals((int)1, (int)rules.size());
                Assert.assertEquals((int)2, (int)r0.getAllowedOrigins().size());
                Assert.assertEquals((int)1, (int)r0.getAllowedMethods().size());
                Assert.assertEquals((int)1, (int)r0.getAllowedHeaders().size());
                Assert.assertEquals((int)2, (int)r0.getExposeHeaders().size());
                Assert.assertEquals((int)100, (int)r0.getMaxAgeSeconds());
                SetBucketCORSRequest.CORSRule r1 = new SetBucketCORSRequest.CORSRule();
                r1.addAllowdOrigin("*");
                r1.addAllowedMethod("GET");
                r1.addAllowedMethod("PUT");
                r1.addAllowedHeader("Authorization");
                request.clearCorsRules();
                request.addCorsRule(r1);
                secondClient.setBucketCORS(request);
                rules = secondClient.getBucketCORSRules("normal-set-bucket-cors");
                r1 = rules.get(0);
                Assert.assertEquals((int)1, (int)rules.size());
                Assert.assertEquals((int)1, (int)r1.getAllowedOrigins().size());
                Assert.assertEquals((int)2, (int)r1.getAllowedMethods().size());
                Assert.assertEquals((int)1, (int)r1.getAllowedHeaders().size());
                secondClient.deleteBucketCORSRules("normal-set-bucket-cors");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-cors");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-cors");
        }
    }

    @Test
    public void testUnormalSetBucketCORS() {
        String bucketName = "unormal-set-bucket-cors";
        try {
            try {
                SetBucketCORSRequest.CORSRule r;
                SetBucketCORSRequest request;
                secondClient.createBucket("unormal-set-bucket-cors");
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    int i = 0;
                    while (i < MAX_CORS_RULE_LIMIT) {
                        request.addCorsRule(r);
                        ++i;
                    }
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    ArrayList<SetBucketCORSRequest.CORSRule> rules = new ArrayList<SetBucketCORSRequest.CORSRule>();
                    int i = 0;
                    while (i < MAX_CORS_RULE_LIMIT) {
                        rules.add(r);
                        ++i;
                    }
                    rules.add(r);
                    request.setCorsRules(rules);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    r.addAllowedMethod("GET");
                    r.addAllowedMethod("PUT");
                    r.addAllowedHeader("Authorization");
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    r.addAllowdOrigin("*");
                    r.addAllowedHeader("Authorization");
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    r.addAllowdOrigin("www.*.abc.*.com");
                    r.addAllowedMethod("GET");
                    r.addAllowedMethod("PUT");
                    r.addAllowedHeader("Authorization");
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    r.addAllowdOrigin("*");
                    r.addAllowedMethod("OPTIONS");
                    r.addAllowedHeader("Authorization");
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
                try {
                    request = new SetBucketCORSRequest("unormal-set-bucket-cors");
                    r = new SetBucketCORSRequest.CORSRule();
                    r.addAllowdOrigin("*");
                    r.addAllowedMethod("GET");
                    r.addAllowedHeader("Authorization");
                    r.addExposeHeader("x-oss-*");
                    request.addCorsRule(r);
                    Assert.fail((String)"Set bucket cors should not be successful");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("unormal-set-bucket-cors");
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-cors");
        }
    }

    @Test
    public void testUnormalGetBucketCORS() {
        String nonexistentBucket = "unormal-get-bucket-cors";
        try {
            secondClient.getBucketCORSRules("unormal-get-bucket-cors");
            Assert.fail((String)"Get bucket cors should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketCORSRules("oss");
            Assert.fail((String)"Get bucket cors should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutCORSRules = "bucket-without-cors-rules";
        try {
            try {
                secondClient.createBucket("bucket-without-cors-rules");
                secondClient.getBucketCORSRules("bucket-without-cors-rules");
                Assert.fail((String)"Get bucket cors should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchCORSConfiguration", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The CORS Configuration does not exist."));
                secondClient.deleteBucket("bucket-without-cors-rules");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-cors-rules");
        }
    }

    @Test
    public void testUnormalDeleteBucketCORS() {
        String nonexistentBucket = "unormal-delete-bucket-cors";
        try {
            secondClient.getBucketCORSRules("unormal-delete-bucket-cors");
            Assert.fail((String)"Delete bucket cors should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketCORSRules("oss");
            Assert.fail((String)"Delete bucket cors should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
    }
}

