/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.utils.CodingUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    private static final String NEW_LINE = "\n";
    private static final List<String> SIGNED_PARAMTERS = Arrays.asList("acl", "uploads", "location", "cors", "logging", "website", "referer", "lifecycle", "delete", "append", "tagging", "objectMeta", "uploadId", "partNumber", "security-token", "position", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "img", "style", "styleName", "replication", "replicationProgress", "replicationLocation", "cname", "bucketInfo", "comp", "qos", "live", "status", "vod", "startTime", "endTime", "x-oss-process", "processConfiguration", "symlink", "stat", "udf", "udfName", "udfImage", "udfImageDesc", "udfApplication", "udfApplicationLog", "restore", "sequential");

    public static String buildCanonicalString(String method, String resourcePath, RequestMessage request, String expires) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method + NEW_LINE);
        Map<String, String> headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String lowerKey;
                if (entry.getKey() == null || !(lowerKey = entry.getKey().toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith("x-oss-")) continue;
                headersToSign.put(lowerKey, entry.getValue().trim());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        for (Map.Entry<String, String> entry : headersToSign.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("x-oss-")) {
                canonicalString.append(key).append(':').append((Object)value);
            } else {
                canonicalString.append((Object)value);
            }
            canonicalString.append(NEW_LINE);
        }
        canonicalString.append(SignUtils.buildCanonicalizedResource(resourcePath, request.getParameters()));
        return canonicalString.toString();
    }

    public static String buildRtmpCanonicalString(String canonicalizedResource, RequestMessage request, String expires) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(expires + NEW_LINE);
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            canonicalString.append(key).append(':').append(value);
            canonicalString.append(NEW_LINE);
        }
        canonicalString.append(canonicalizedResource);
        return canonicalString.toString();
    }

    private static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        CodingUtils.assertTrue(resourcePath.startsWith("/"), "Resource path should start with slash character");
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separater = 63;
            for (Object paramName : parameterNames) {
                if (!SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separater);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (paramValue != null) {
                    builder.append("=").append(paramValue);
                }
                separater = 38;
            }
        }
        return builder.toString();
    }
}

