/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import java.text.MessageFormat;

public class RoutingRule {
    private int number;
    private Condition condition = new Condition();
    private Redirect redirect = new Redirect();

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Redirect getRedirect() {
        return this.redirect;
    }

    public void setRedirect(Redirect redirect) {
        this.redirect = redirect;
    }

    public void ensureRoutingRuleValid() {
        if (this.number <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("RoutingRuleNumberInvalid", this.number));
        }
        this.redirect.ensureRedirectValid();
        this.condition.ensureConditionValid();
    }

    public class Redirect {
        private RedirectType redirectType;
        private String hostName;
        private Protocol protocol;
        private String replaceKeyPrefixWith;
        private String replaceKeyWith;
        private int httpRedirectCode = -1;
        private String mirrorURL;

        public RedirectType getRedirectType() {
            return this.redirectType;
        }

        public void setRedirectType(RedirectType redirectType) {
            this.redirectType = redirectType;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }

        public String getReplaceKeyPrefixWith() {
            return this.replaceKeyPrefixWith;
        }

        public void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        public String getReplaceKeyWith() {
            return this.replaceKeyWith;
        }

        public void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        public int getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        public void setHttpRedirectCode(int httpRedirectCode) {
            if (httpRedirectCode < 300 || httpRedirectCode > 399) {
                throw new IllegalArgumentException(MessageFormat.format("RedirectHttpRedirectCodeInvalid", "HttpRedirectCode must be a valid HTTP 3xx status code."));
            }
            this.httpRedirectCode = httpRedirectCode;
        }

        public String getMirrorURL() {
            return this.mirrorURL;
        }

        public void setMirrorURL(String mirrorURL) {
            this.mirrorURL = mirrorURL;
        }

        public void ensureRedirectValid() {
            if (this.hostName == null && this.protocol == null && this.replaceKeyPrefixWith == null && this.replaceKeyWith == null && this.httpRedirectCode == -1 && this.mirrorURL == null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "Redirect element must contain at least one of the sibling elements"));
            }
            if (this.replaceKeyPrefixWith != null && this.replaceKeyWith != null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "ReplaceKeyPrefixWith or ReplaceKeyWith only choose one"));
            }
            if (this.redirectType == RedirectType.Mirror && this.mirrorURL == null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "MirrorURL must have a value"));
            }
            if (!(this.redirectType != RedirectType.Mirror || (this.mirrorURL.startsWith("http://") || this.mirrorURL.startsWith("https://")) && this.mirrorURL.endsWith("/"))) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "MirrorURL is invalid", this.mirrorURL));
            }
        }
    }

    public static enum Protocol {
        Http("http"),
        Https("https");

        private String protocolString;

        private Protocol(String protocolString) {
            this.protocolString = protocolString;
        }

        public String toString() {
            return this.protocolString;
        }

        public static Protocol parse(String protocolString) {
            for (Protocol protocol : Protocol.values()) {
                if (!protocol.toString().equals(protocolString)) continue;
                return protocol;
            }
            throw new IllegalArgumentException("Unable to parse " + protocolString);
        }
    }

    public static enum RedirectType {
        External("External"),
        Mirror("Mirror");

        private String redirectTypeString;

        private RedirectType(String redirectTypeString) {
            this.redirectTypeString = redirectTypeString;
        }

        public String toString() {
            return this.redirectTypeString;
        }

        public static RedirectType parse(String redirectTypeString) {
            for (RedirectType rt : RedirectType.values()) {
                if (!rt.toString().equals(redirectTypeString)) continue;
                return rt;
            }
            throw new IllegalArgumentException("Unable to parse " + redirectTypeString);
        }
    }

    public class Condition {
        private String keyPrefixEquals;
        private int httpErrorCodeReturnedEquals = -1;

        public String getKeyPrefixEquals() {
            return this.keyPrefixEquals;
        }

        public void setKeyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
        }

        public int getHttpErrorCodeReturnedEquals() {
            return this.httpErrorCodeReturnedEquals;
        }

        public void setHttpErrorCodeReturnedEquals(int httpErrorCodeReturnedEquals) {
            if (httpErrorCodeReturnedEquals <= 0) {
                throw new IllegalArgumentException(MessageFormat.format("HttpErrorCodeReturnedEqualsInvalid", "HttpErrorCodeReturnedEquals should be greater than 0"));
            }
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
        }

        public void ensureConditionValid() {
        }
    }
}

