/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.crypto.AdjustedRangeInputStream;
import com.aliyun.oss.crypto.CipherInputStream;
import com.aliyun.oss.crypto.ContentCryptoMaterial;
import com.aliyun.oss.crypto.ContentCryptoMaterialRW;
import com.aliyun.oss.crypto.ContentCryptoMode;
import com.aliyun.oss.crypto.CryptoCipher;
import com.aliyun.oss.crypto.CryptoConfiguration;
import com.aliyun.oss.crypto.CryptoModule;
import com.aliyun.oss.crypto.CryptoScheme;
import com.aliyun.oss.crypto.EncryptionMaterials;
import com.aliyun.oss.crypto.MultipartUploadCryptoContext;
import com.aliyun.oss.crypto.OSSDirect;
import com.aliyun.oss.crypto.RenewableCipherInputStream;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.aliyun.oss.model.WebServiceRequest;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class CryptoModuleBase
implements CryptoModule {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterials encryptionMaterials;
    protected final CryptoScheme contentCryptoScheme;
    protected final CryptoConfiguration cryptoConfig;
    protected final OSSDirect ossDirect;
    protected final String encryptionClientUserAgent;

    protected CryptoModuleBase(OSSDirect ossDirect, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this.encryptionMaterials = encryptionMaterials;
        this.ossDirect = ossDirect;
        this.cryptoConfig = cryptoConfig;
        this.contentCryptoScheme = CryptoModuleBase.getCryptoScheme(cryptoConfig.getContentCryptoMode());
        this.encryptionClientUserAgent = this.ossDirect.getInnerClientConfiguration().getUserAgent() + "/OSSEncryptionClient";
    }

    private static final CryptoScheme getCryptoScheme(ContentCryptoMode contentCryptoMode) {
        switch (contentCryptoMode) {
            default: 
        }
        return CryptoScheme.AES_CTR;
    }

    abstract byte[] generateIV();

    abstract CryptoCipher createCryptoCipherFromContentMaterial(ContentCryptoMaterial var1, int var2, long[] var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest req) {
        this.setUserAgent(req, this.encryptionClientUserAgent);
        ContentCryptoMaterial cekMaterial = this.buildContentCryptoMaterials();
        ObjectMetadata meta = this.updateMetadataWithContentCryptoMaterial(req.getMetadata(), req.getFile(), cekMaterial);
        req.setMetadata(meta);
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        PutObjectRequest wrappedReq = this.wrapPutRequestWithCipher(req, cekMaterial);
        try {
            PutObjectResult putObjectResult = this.ossDirect.putObject(wrappedReq);
            return putObjectResult;
        }
        finally {
            this.safeCloseSource(wrappedReq.getInputStream());
            req.setFile(fileOrig);
            req.setInputStream(isOrig);
        }
    }

    protected final PutObjectRequest wrapPutRequestWithCipher(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.updateContentMd5(request, metadata);
        this.updateContentLength(request, metadata);
        CryptoCipher cryptoCipher = this.createCryptoCipherFromContentMaterial(cekMaterial, 1, null, 0L);
        request.setInputStream(this.newOSSCryptoCipherInputStream(request, cryptoCipher));
        request.setFile(null);
        return request;
    }

    private void updateContentMd5(PutObjectRequest request, ObjectMetadata metadata) {
        Map<String, String> headers;
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-md5", metadata.getContentMD5());
            metadata.removeHeader("Content-MD5");
        }
        if ((headers = request.getHeaders()).containsKey("Content-MD5")) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-md5", headers.get("Content-MD5"));
            headers.remove("Content-MD5");
        }
        request.setMetadata(metadata);
    }

    private void updateContentLength(PutObjectRequest request, ObjectMetadata metadata) {
        Map<String, String> headers;
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(plaintextLength);
        }
        if ((headers = request.getHeaders()).containsKey("Content-Length")) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-length", headers.get("Content-Length"));
        }
        request.setMetadata(metadata);
    }

    public static boolean hasEncryptionInfo(ObjectMetadata metadata) {
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("client-side-encryption-key") && userMeta.containsKey("client-side-encryption-start");
    }

    @Override
    public OSSObject getObjectSecurely(GetObjectRequest req) {
        OSSObject retrieved;
        String contentRange;
        this.setUserAgent(req, this.encryptionClientUserAgent);
        long[] desiredRange = req.getRange();
        long[] adjustedCryptoRange = this.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        if ((contentRange = (String)(retrieved = this.ossDirect.getObject(req)).getObjectMetadata().getRawMetadata().get("Content-Range")) == null && adjustedCryptoRange != null) {
            desiredRange[0] = 0L;
            desiredRange[1] = retrieved.getObjectMetadata().getContentLength() - 1L;
            adjustedCryptoRange = (long[])desiredRange.clone();
        }
        try {
            if (CryptoModuleBase.hasEncryptionInfo(retrieved.getObjectMetadata())) {
                return this.decipherWithMetadata(req, desiredRange, adjustedCryptoRange, retrieved);
            }
            OSSObject adjustedOSSObject = this.adjustToDesiredRange(retrieved, desiredRange);
            return adjustedOSSObject;
        }
        catch (Exception e) {
            this.safeCloseSource(retrieved);
            throw new ClientException(e);
        }
    }

    protected OSSObject decipherWithMetadata(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, OSSObject retrieved) {
        ContentCryptoMaterial cekMaterial = this.createContentMaterialFromMetadata(retrieved.getObjectMetadata());
        CryptoCipher cryptoCipher = this.createCryptoCipherFromContentMaterial(cekMaterial, 2, cryptoRange, 0L);
        InputStream objectContent = retrieved.getObjectContent();
        retrieved.setObjectContent(new CipherInputStream(objectContent, cryptoCipher, 2048));
        OSSObject adjusted = this.adjustToDesiredRange(retrieved, desiredRange);
        return adjusted;
    }

    protected void safeCloseSource(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final OSSObject adjustToDesiredRange(OSSObject OSSobject, long[] range) {
        if (range == null) {
            return OSSobject;
        }
        try {
            InputStream objectContent = OSSobject.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            OSSobject.setObjectContent(adjustedRangeContents);
            return OSSobject;
        }
        catch (IOException e) {
            throw new ClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    private void checkMultipartContext(MultipartUploadCryptoContext context) {
        if (context == null) {
            throw new IllegalArgumentException("MultipartUploadCryptoContext should not be null.");
        }
        if (0L != context.getPartSize() % 16L || context.getPartSize() <= 0L) {
            throw new IllegalArgumentException("MultipartUploadCryptoContext part size is not 16 bytes alignment.");
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        ObjectMetadata objectMetadata;
        CodingUtils.assertParameterNotNull(file, "file");
        OSSObject ossObject = this.getObjectSecurely(getObjectRequest);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            if (this.ossDirect.getInnerClientConfiguration().isCrcCheckEnabled() && getObjectRequest.getRange() == null) {
                Long clientCRC = null;
                InputStream contentInputStream = ossObject.getObjectContent();
                if (contentInputStream instanceof CipherInputStream) {
                    InputStream subStream = ((CipherInputStream)contentInputStream).getDelegateStream();
                    if (subStream instanceof CheckedInputStream) {
                        clientCRC = ((CheckedInputStream)subStream).getChecksum().getValue();
                    }
                } else {
                    clientCRC = IOUtils.getCRCValue(ossObject.getObjectContent());
                }
                OSSUtils.checkChecksum(clientCRC, ossObject.getServerCRC(), ossObject.getRequestId());
            }
            objectMetadata = ossObject.getObjectMetadata();
        }
        catch (IOException ex) {
            try {
                LogUtils.logException("Cannot read object content stream: ", ex);
                throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), ex);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
        return objectMetadata;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req, MultipartUploadCryptoContext context) {
        this.checkMultipartContext(context);
        this.setUserAgent(req, this.encryptionClientUserAgent);
        ContentCryptoMaterial cekMaterial = this.buildContentCryptoMaterials();
        ObjectMetadata metadata = req.getObjectMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        metadata = this.updateMetadataWithContentCryptoMaterial(metadata, null, cekMaterial);
        metadata = this.updateMetadataWithUploadContext(metadata, context);
        req.setObjectMetadata(metadata);
        InitiateMultipartUploadResult result = this.ossDirect.initiateMultipartUpload(req);
        context.setUploadId(result.getUploadId());
        context.setContentCryptoMaterial(cekMaterial);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req, MultipartUploadCryptoContext context) {
        UploadPartResult result;
        this.checkMultipartContext(context);
        if (!context.getUploadId().equals(req.getUploadId())) {
            throw new ClientException("The multipartUploadCryptoContextcontext input upload id is invalid.context uploadid:" + context.getUploadId() + ",uploadRequest uploadid:" + req.getUploadId());
        }
        this.setUserAgent(req, this.encryptionClientUserAgent);
        long offset = context.getPartSize() * (long)(req.getPartNumber() - 1);
        long skipBlock = offset / 16L;
        CryptoCipher cryptoCipher = this.createCryptoCipherFromContentMaterial(context.getContentCryptoMaterial(), 1, null, skipBlock);
        InputStream isOrig = req.getInputStream();
        RenewableCipherInputStream isCurr = null;
        try {
            isCurr = new RenewableCipherInputStream(isOrig, cryptoCipher, 2048);
            req.setInputStream(isCurr);
            result = this.ossDirect.uploadPart(req);
            this.safeCloseSource(isCurr);
            req.setInputStream(isOrig);
        }
        catch (Throwable throwable) {
            this.safeCloseSource(isCurr);
            req.setInputStream(isOrig);
            throw throwable;
        }
        return result;
    }

    private CipherInputStream newOSSCryptoCipherInputStream(PutObjectRequest req, CryptoCipher cryptoCipher) {
        InputStream isOrig;
        File fileOrig = req.getFile();
        InputStream isCurr = isOrig = req.getInputStream();
        try {
            if (fileOrig != null) {
                isCurr = new FileInputStream(fileOrig);
            }
            return new RenewableCipherInputStream(isCurr, cryptoCipher, 2048);
        }
        catch (Exception e) {
            this.safeCloseSource(isCurr);
            req.setFile(fileOrig);
            req.setInputStream(isOrig);
            throw new ClientException("Unable to create cipher input stream." + e.getMessage(), e);
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getRawMetadata().get("Content-Length") != null) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    long[] getAdjustedCryptoRange(long[] range) {
        if (range == null) {
            return null;
        }
        if (range[0] > range[1] || range[0] < 0L || range[1] <= 0L) {
            throw new ClientException("Your input get-range is illegal. + range:" + range[0] + "~" + range[1]);
        }
        long[] adjustedCryptoRange = new long[]{this.getCipherBlockLowerBound(range[0]), range[1]};
        return adjustedCryptoRange;
    }

    private long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset;
        return lowerBound;
    }

    protected final ContentCryptoMaterial buildContentCryptoMaterials() {
        byte[] iv = this.generateIV();
        SecretKey cek = this.generateCEK();
        ContentCryptoMaterialRW contentMaterialRW = new ContentCryptoMaterialRW();
        contentMaterialRW.setIV(iv);
        contentMaterialRW.setCEK(cek);
        contentMaterialRW.setContentCryptoAlgorithm(this.contentCryptoScheme.getContentChiperAlgorithm());
        this.encryptionMaterials.encryptCEK(contentMaterialRW);
        return contentMaterialRW;
    }

    protected final ObjectMetadata updateMetadataWithUploadContext(ObjectMetadata metadata, MultipartUploadCryptoContext context) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        metadata.addUserMetadata("client-side-encryption-part-size", String.valueOf(context.getPartSize()));
        if (context.getDataSize() > 0L) {
            metadata.addUserMetadata("client-side-encryption-data-size", String.valueOf(context.getDataSize()));
        }
        return metadata;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial contentCryptoMaterial) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(file));
        }
        byte[] encryptedCEK = contentCryptoMaterial.getEncryptedCEK();
        metadata.addUserMetadata("client-side-encryption-key", BinaryUtil.toBase64String(encryptedCEK));
        byte[] encryptedIV = contentCryptoMaterial.getEncryptedIV();
        metadata.addUserMetadata("client-side-encryption-start", BinaryUtil.toBase64String(encryptedIV));
        String contentCryptoAlgo = contentCryptoMaterial.getContentCryptoAlgorithm();
        metadata.addUserMetadata("client-side-encryption-cek-alg", contentCryptoAlgo);
        String keyWrapAlgo = contentCryptoMaterial.getKeyWrapAlgorithm();
        metadata.addUserMetadata("client-side-encryption-wrap-alg", keyWrapAlgo);
        Map<String, String> materialDesc = contentCryptoMaterial.getMaterialsDescription();
        if (materialDesc != null && materialDesc.size() > 0) {
            JSONObject descJson = new JSONObject(materialDesc);
            String descStr = descJson.toString();
            metadata.addUserMetadata("client-side-encryption-matdesc", descStr);
        }
        return metadata;
    }

    protected ContentCryptoMaterial createContentMaterialFromMetadata(ObjectMetadata meta) {
        Map<String, String> userMeta = meta.getUserMetadata();
        String b64CEK = userMeta.get("client-side-encryption-key");
        String b64IV = userMeta.get("client-side-encryption-start");
        if (b64CEK == null || b64IV == null) {
            throw new ClientException("Content encrypted key  or encrypted iv not found.");
        }
        byte[] encryptedCEK = BinaryUtil.fromBase64String(b64CEK);
        byte[] encryptedIV = BinaryUtil.fromBase64String(b64IV);
        String keyWrapAlgo = userMeta.get("client-side-encryption-wrap-alg");
        if (keyWrapAlgo == null) {
            throw new ClientException("Key wrap algorithm should not be null.");
        }
        String cekAlgo = userMeta.get("client-side-encryption-cek-alg");
        String mateDescString = userMeta.get("client-side-encryption-matdesc");
        Map<String, String> matDesc = CryptoModuleBase.getDescFromJsonString(mateDescString);
        ContentCryptoMaterialRW contentMaterialRW = new ContentCryptoMaterialRW();
        contentMaterialRW.setEncryptedCEK(encryptedCEK);
        contentMaterialRW.setEncryptedIV(encryptedIV);
        contentMaterialRW.setMaterialsDescription(matDesc);
        contentMaterialRW.setContentCryptoAlgorithm(cekAlgo);
        contentMaterialRW.setKeyWrapAlgorithm(keyWrapAlgo);
        this.encryptionMaterials.decryptCEK(contentMaterialRW);
        return contentMaterialRW;
    }

    protected static Map<String, String> getDescFromJsonString(String jsonString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (jsonString == null) {
            return map;
        }
        try {
            JSONObject obj = new JSONObject(jsonString);
            Iterator iter = obj.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = obj.getString(key);
                map.put(key, value);
            }
            return map;
        }
        catch (JSONException e) {
            throw new ClientException("Unable to parse Json string:json", e);
        }
    }

    protected SecretKey generateCEK() {
        String keygenAlgo = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        int keyLength = this.contentCryptoScheme.getKeyLengthInBits();
        try {
            KeyGenerator generator = KeyGenerator.getInstance(keygenAlgo);
            generator.init(keyLength, this.cryptoConfig.getSecureRandom());
            SecretKey secretKey = generator.generateKey();
            for (int retry = 0; retry < 9; ++retry) {
                secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw new ClientException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("No such algorithm:" + keygenAlgo + ", " + e.getMessage(), e);
        }
    }

    protected void setUserAgent(WebServiceRequest req, String userAgent) {
        req.addHeader("User-Agent", userAgent);
    }
}

