/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketMetadata;
import com.aliyun.oss.model.BucketProcess;
import com.aliyun.oss.model.BucketQosInfo;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketReplicationProgress;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.BucketVersioningConfiguration;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CnameConfiguration;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateLiveChannelResult;
import com.aliyun.oss.model.DataRedundancyType;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DeleteVersionsResult;
import com.aliyun.oss.model.GenericResult;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetBucketPolicyResult;
import com.aliyun.oss.model.GetBucketRequestPaymentResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.ImageProcess;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.LiveChannel;
import com.aliyun.oss.model.LiveChannelInfo;
import com.aliyun.oss.model.LiveChannelListing;
import com.aliyun.oss.model.LiveChannelStat;
import com.aliyun.oss.model.LiveChannelStatus;
import com.aliyun.oss.model.LiveChannelTarget;
import com.aliyun.oss.model.LiveRecord;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.OSSVersionSummary;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.ObjectPermission;
import com.aliyun.oss.model.Owner;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.Permission;
import com.aliyun.oss.model.PushflowStatus;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ReplicationRule;
import com.aliyun.oss.model.ReplicationStatus;
import com.aliyun.oss.model.RestoreObjectResult;
import com.aliyun.oss.model.RoutingRule;
import com.aliyun.oss.model.ServerSideEncryptionByDefault;
import com.aliyun.oss.model.ServerSideEncryptionConfiguration;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import com.aliyun.oss.model.StorageClass;
import com.aliyun.oss.model.Style;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.UserQosInfo;
import com.aliyun.oss.model.VersionListing;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.apache.hadoop.fs.aliyun.shaded.org.jdom.Document;
import org.apache.hadoop.fs.aliyun.shaded.org.jdom.Element;
import org.apache.hadoop.fs.aliyun.shaded.org.jdom.input.JDOMParseException;
import org.apache.hadoop.fs.aliyun.shaded.org.jdom.input.SAXBuilder;

public final class ResponseParsers {
    public static final ListBucketResponseParser listBucketResponseParser = new ListBucketResponseParser();
    public static final ListImageStyleResponseParser listImageStyleResponseParser = new ListImageStyleResponseParser();
    public static final GetBucketRefererResponseParser getBucketRefererResponseParser = new GetBucketRefererResponseParser();
    public static final GetBucketAclResponseParser getBucketAclResponseParser = new GetBucketAclResponseParser();
    public static final GetBucketMetadataResponseParser getBucketMetadataResponseParser = new GetBucketMetadataResponseParser();
    public static final GetBucketLocationResponseParser getBucketLocationResponseParser = new GetBucketLocationResponseParser();
    public static final GetBucketLoggingResponseParser getBucketLoggingResponseParser = new GetBucketLoggingResponseParser();
    public static final GetBucketWebsiteResponseParser getBucketWebsiteResponseParser = new GetBucketWebsiteResponseParser();
    public static final GetBucketLifecycleResponseParser getBucketLifecycleResponseParser = new GetBucketLifecycleResponseParser();
    public static final GetBucketCorsResponseParser getBucketCorsResponseParser = new GetBucketCorsResponseParser();
    public static final GetBucketImageResponseParser getBucketImageResponseParser = new GetBucketImageResponseParser();
    public static final GetImageStyleResponseParser getImageStyleResponseParser = new GetImageStyleResponseParser();
    public static final GetBucketImageProcessConfResponseParser getBucketImageProcessConfResponseParser = new GetBucketImageProcessConfResponseParser();
    public static final GetTaggingResponseParser getTaggingResponseParser = new GetTaggingResponseParser();
    public static final GetBucketReplicationResponseParser getBucketReplicationResponseParser = new GetBucketReplicationResponseParser();
    public static final GetBucketReplicationProgressResponseParser getBucketReplicationProgressResponseParser = new GetBucketReplicationProgressResponseParser();
    public static final GetBucketReplicationLocationResponseParser getBucketReplicationLocationResponseParser = new GetBucketReplicationLocationResponseParser();
    public static final GetBucketCnameResponseParser getBucketCnameResponseParser = new GetBucketCnameResponseParser();
    public static final GetBucketInfoResponseParser getBucketInfoResponseParser = new GetBucketInfoResponseParser();
    public static final GetBucketStatResponseParser getBucketStatResponseParser = new GetBucketStatResponseParser();
    public static final GetBucketQosResponseParser getBucketQosResponseParser = new GetBucketQosResponseParser();
    public static final GetBucketVersioningResponseParser getBucketVersioningResponseParser = new GetBucketVersioningResponseParser();
    public static final GetBucketEncryptionResponseParser getBucketEncryptionResponseParser = new GetBucketEncryptionResponseParser();
    public static final GetBucketPolicyResponseParser getBucketPolicyResponseParser = new GetBucketPolicyResponseParser();
    public static final GetBucketRequestPaymentResponseParser getBucketRequestPaymentResponseParser = new GetBucketRequestPaymentResponseParser();
    public static final GetUSerQosInfoResponseParser getUSerQosInfoResponseParser = new GetUSerQosInfoResponseParser();
    public static final GetBucketQosInfoResponseParser getBucketQosInfoResponseParser = new GetBucketQosInfoResponseParser();
    public static final ListObjectsReponseParser listObjectsReponseParser = new ListObjectsReponseParser();
    public static final ListVersionsReponseParser listVersionsReponseParser = new ListVersionsReponseParser();
    public static final PutObjectReponseParser putObjectReponseParser = new PutObjectReponseParser();
    public static final PutObjectProcessReponseParser putObjectProcessReponseParser = new PutObjectProcessReponseParser();
    public static final AppendObjectResponseParser appendObjectResponseParser = new AppendObjectResponseParser();
    public static final GetObjectMetadataResponseParser getObjectMetadataResponseParser = new GetObjectMetadataResponseParser();
    public static final CopyObjectResponseParser copyObjectResponseParser = new CopyObjectResponseParser();
    public static final DeleteObjectsResponseParser deleteObjectsResponseParser = new DeleteObjectsResponseParser();
    public static final DeleteVersionsResponseParser deleteVersionsResponseParser = new DeleteVersionsResponseParser();
    public static final GetObjectAclResponseParser getObjectAclResponseParser = new GetObjectAclResponseParser();
    public static final GetSimplifiedObjectMetaResponseParser getSimplifiedObjectMetaResponseParser = new GetSimplifiedObjectMetaResponseParser();
    public static final RestoreObjectResponseParser restoreObjectResponseParser = new RestoreObjectResponseParser();
    public static final ProcessObjectResponseParser processObjectResponseParser = new ProcessObjectResponseParser();
    public static final HeadObjectResponseParser headObjectResponseParser = new HeadObjectResponseParser();
    public static final CompleteMultipartUploadResponseParser completeMultipartUploadResponseParser = new CompleteMultipartUploadResponseParser();
    public static final CompleteMultipartUploadProcessResponseParser completeMultipartUploadProcessResponseParser = new CompleteMultipartUploadProcessResponseParser();
    public static final InitiateMultipartUploadResponseParser initiateMultipartUploadResponseParser = new InitiateMultipartUploadResponseParser();
    public static final ListMultipartUploadsResponseParser listMultipartUploadsResponseParser = new ListMultipartUploadsResponseParser();
    public static final ListPartsResponseParser listPartsResponseParser = new ListPartsResponseParser();
    public static final CreateLiveChannelResponseParser createLiveChannelResponseParser = new CreateLiveChannelResponseParser();
    public static final GetLiveChannelInfoResponseParser getLiveChannelInfoResponseParser = new GetLiveChannelInfoResponseParser();
    public static final GetLiveChannelStatResponseParser getLiveChannelStatResponseParser = new GetLiveChannelStatResponseParser();
    public static final GetLiveChannelHistoryResponseParser getLiveChannelHistoryResponseParser = new GetLiveChannelHistoryResponseParser();
    public static final ListLiveChannelsReponseParser listLiveChannelsReponseParser = new ListLiveChannelsReponseParser();
    public static final GetSymbolicLinkResponseParser getSymbolicLinkResponseParser = new GetSymbolicLinkResponseParser();

    public static <ResultType extends GenericResult> void setCRC(ResultType result, ResponseMessage response) {
        String strSrvCrc;
        InputStream inputStream = response.getRequest().getContent();
        if (inputStream instanceof CheckedInputStream) {
            CheckedInputStream checkedInputStream = (CheckedInputStream)inputStream;
            result.setClientCRC(checkedInputStream.getChecksum().getValue());
        }
        if ((strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma")) != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }

    public static <ResultType extends GenericResult> void setServerCRC(ResultType result, ResponseMessage response) {
        String strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma");
        if (strSrvCrc != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }

    private static Element getXmlRootElement(InputStream responseBody) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(responseBody);
        return doc.getRootElement();
    }

    public static ObjectListing parseListObjects(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectListing objectListing = new ObjectListing();
            objectListing.setBucketName(root.getChildText("Name"));
            objectListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            objectListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                objectListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                objectListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                objectListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : delimiter);
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                objectListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                objectListing.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            List objectSummaryElems = root.getChildren("Contents");
            for (Element elem : objectSummaryElems) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(elem.getChildText("Key"));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossObjectSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossObjectSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossObjectSummary.setBucketName(objectListing.getBucketName());
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossObjectSummary.setOwner(new Owner(id, displayName));
                objectListing.addObjectSummary(ossObjectSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                objectListing.addCommonPrefix(prefix);
            }
            return objectListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static VersionListing parseListVersions(InputStream responseBody) throws ResponseParseException {
        try {
            String nextMarker;
            String marker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean shouldSDKDecode = false;
            VersionListing versionListing = new VersionListing();
            versionListing.setBucketName(root.getChildText("Name"));
            versionListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            versionListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                if (encodingType.equals("url")) {
                    shouldSDKDecode = true;
                    versionListing.setEncodingType(null);
                } else {
                    versionListing.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
                }
            }
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                versionListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : ResponseParsers.decodeIfSpecified(prefix, shouldSDKDecode));
            }
            if (root.getChild("KeyMarker") != null) {
                marker = root.getChildText("KeyMarker");
                versionListing.setKeyMarker(CodingUtils.isNullOrEmpty(marker) ? null : ResponseParsers.decodeIfSpecified(marker, shouldSDKDecode));
            }
            if (root.getChild("VersionIdMarker") != null) {
                marker = root.getChildText("VersionIdMarker");
                versionListing.setVersionIdMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                versionListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : ResponseParsers.decodeIfSpecified(delimiter, shouldSDKDecode));
            }
            if (root.getChild("NextKeyMarker") != null) {
                nextMarker = root.getChildText("NextKeyMarker");
                versionListing.setNextKeyMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : ResponseParsers.decodeIfSpecified(nextMarker, shouldSDKDecode));
            }
            if (root.getChild("NextVersionIdMarker") != null) {
                nextMarker = root.getChildText("NextVersionIdMarker");
                versionListing.setNextVersionIdMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List objectSummaryElems = root.getChildren("Version");
            for (Element elem : objectSummaryElems) {
                OSSVersionSummary ossVersionSummary = new OSSVersionSummary();
                ossVersionSummary.setKey(ResponseParsers.decodeIfSpecified(elem.getChildText("Key"), shouldSDKDecode));
                ossVersionSummary.setVersionId(elem.getChildText("VersionId"));
                ossVersionSummary.setIsLatest("true".equals(elem.getChildText("IsLatest")));
                ossVersionSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossVersionSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossVersionSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossVersionSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossVersionSummary.setBucketName(versionListing.getBucketName());
                ossVersionSummary.setIsDeleteMarker(false);
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossVersionSummary.setOwner(new Owner(id, displayName));
                versionListing.getVersionSummaries().add(ossVersionSummary);
            }
            List delSummaryElems = root.getChildren("DeleteMarker");
            for (Element elem : delSummaryElems) {
                OSSVersionSummary ossVersionSummary = new OSSVersionSummary();
                ossVersionSummary.setKey(ResponseParsers.decodeIfSpecified(elem.getChildText("Key"), shouldSDKDecode));
                ossVersionSummary.setVersionId(elem.getChildText("VersionId"));
                ossVersionSummary.setIsLatest("true".equals(elem.getChildText("IsLatest")));
                ossVersionSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossVersionSummary.setBucketName(versionListing.getBucketName());
                ossVersionSummary.setIsDeleteMarker(true);
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossVersionSummary.setOwner(new Owner(id, displayName));
                versionListing.getVersionSummaries().add(ossVersionSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                versionListing.getCommonPrefixes().add(ResponseParsers.decodeIfSpecified(prefix, shouldSDKDecode));
            }
            return versionListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    private static String decodeIfSpecified(String value, boolean decode) {
        return decode ? HttpUtil.urlDecode(value, "UTF-8") : value;
    }

    public static AccessControlList parseGetBucketAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            AccessControlList acl = new AccessControlList();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String aclString = root.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList cacl = CannedAccessControlList.parse(aclString);
            acl.setCannedACL(cacl);
            switch (cacl) {
                case PublicRead: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectAcl parseGetObjectAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectAcl acl = new ObjectAcl();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String grantString = root.getChild("AccessControlList").getChildText("Grant");
            acl.setPermission(ObjectPermission.parsePermission(grantString));
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReferer parseGetBucketReferer(InputStream responseBody) throws ResponseParseException {
        try {
            Element refererListElem;
            List refererElems;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean allowEmptyReferer = Boolean.valueOf(root.getChildText("AllowEmptyReferer"));
            ArrayList<String> refererList = new ArrayList<String>();
            if (root.getChild("RefererList") != null && (refererElems = (refererListElem = root.getChild("RefererList")).getChildren("Referer")) != null && !refererElems.isEmpty()) {
                for (Element e : refererElems) {
                    refererList.add(e.getText());
                }
            }
            return new BucketReferer(allowEmptyReferer, refererList);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseUploadPartCopy(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getChildText("ETag");
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketList parseListBucket(InputStream responseBody) throws ResponseParseException {
        try {
            String value;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketList bucketList = new BucketList();
            if (root.getChild("Prefix") != null) {
                bucketList.setPrefix(root.getChildText("Prefix"));
            }
            if (root.getChild("Marker") != null) {
                bucketList.setMarker(root.getChildText("Marker"));
            }
            if (root.getChild("MaxKeys") != null) {
                value = root.getChildText("MaxKeys");
                bucketList.setMaxKeys(CodingUtils.isNullOrEmpty(value) ? null : Integer.valueOf(value));
            }
            if (root.getChild("IsTruncated") != null) {
                value = root.getChildText("IsTruncated");
                bucketList.setTruncated(CodingUtils.isNullOrEmpty(value) ? false : Boolean.valueOf(value));
            }
            if (root.getChild("NextMarker") != null) {
                bucketList.setNextMarker(root.getChildText("NextMarker"));
            }
            Element ownerElem = root.getChild("Owner");
            String id = ownerElem.getChildText("ID");
            String displayName = ownerElem.getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>();
            if (root.getChild("Buckets") != null) {
                List bucketElems = root.getChild("Buckets").getChildren("Bucket");
                for (Element e : bucketElems) {
                    Bucket bucket = new Bucket();
                    bucket.setOwner(owner);
                    bucket.setName(e.getChildText("Name"));
                    bucket.setLocation(e.getChildText("Location"));
                    bucket.setCreationDate(DateUtil.parseIso8601Date(e.getChildText("CreationDate")));
                    if (e.getChild("StorageClass") != null) {
                        bucket.setStorageClass(StorageClass.parse(e.getChildText("StorageClass")));
                    }
                    bucket.setExtranetEndpoint(e.getChildText("ExtranetEndpoint"));
                    bucket.setIntranetEndpoint(e.getChildText("IntranetEndpoint"));
                    buckets.add(bucket);
                }
            }
            bucketList.setBucketList(buckets);
            return bucketList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<Style> parseListImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<Style> styleList = new ArrayList<Style>();
            List styleElems = root.getChildren("Style");
            for (Element e : styleElems) {
                Style style = new Style();
                style.SetStyleName(e.getChildText("Name"));
                style.SetStyle(e.getChildText("Content"));
                style.SetLastModifyTime(DateUtil.parseRfc822Date(e.getChildText("LastModifyTime")));
                style.SetCreationDate(DateUtil.parseRfc822Date(e.getChildText("CreateTime")));
                styleList.add(style);
            }
            return styleList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseGetBucketLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getText();
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketMetadata parseBucketMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            BucketMetadata bucketMetadata = new BucketMetadata();
            for (String key : headers.keySet()) {
                if (key.equals("x-oss-bucket-region")) {
                    bucketMetadata.setBucketRegion(headers.get(key));
                    continue;
                }
                bucketMetadata.addHttpMetadata(key, headers.get(key));
            }
            return bucketMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static SimplifiedObjectMeta parseSimplifiedObjectMeta(Map<String, String> headers) throws ResponseParseException {
        try {
            SimplifiedObjectMeta objectMeta = new SimplifiedObjectMeta();
            for (String key : headers.keySet()) {
                if (key.equals("Last-Modified")) {
                    try {
                        objectMeta.setLastModified(DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMeta.setSize(value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMeta.setETag(OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                if (key.equals("x-oss-request-id")) {
                    objectMeta.setRequestId(headers.get(key));
                    continue;
                }
                if (!key.equals("x-oss-version-id")) continue;
                objectMeta.setVersionId(headers.get(key));
            }
            return objectMeta;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static OSSSymlink parseSymbolicLink(ResponseMessage response) throws ResponseParseException {
        try {
            OSSSymlink smyLink = null;
            String targetObject = response.getHeaders().get("x-oss-symlink-target");
            if (targetObject != null) {
                targetObject = HttpUtil.urlDecode(targetObject, "UTF-8");
                smyLink = new OSSSymlink(null, targetObject);
            }
            smyLink.setMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
            return smyLink;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    key = key.substring("x-oss-meta-".length());
                    objectMetadata.addUserMetadata(key, headers.get("x-oss-meta-" + key));
                    continue;
                }
                if (key.equals("Last-Modified") || key.equals("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static InitiateMultipartUploadResult parseInitiateMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
            if (root.getChild("Bucket") != null) {
                result.setBucketName(root.getChildText("Bucket"));
            }
            if (root.getChild("Key") != null) {
                result.setKey(root.getChildText("Key"));
            }
            if (root.getChild("UploadId") != null) {
                result.setUploadId(root.getChildText("UploadId"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static MultipartUploadListing parseListMultipartUploads(InputStream responseBody) throws ResponseParseException {
        try {
            String nextUploadIdMarker;
            String nextKeyMarker;
            String uploadIdMarker;
            String keyMarker;
            String prefix;
            String delimiter;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            MultipartUploadListing multipartUploadListing = new MultipartUploadListing();
            multipartUploadListing.setBucketName(root.getChildText("Bucket"));
            multipartUploadListing.setMaxUploads(Integer.valueOf(root.getChildText("MaxUploads")));
            multipartUploadListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Delimiter") != null && !CodingUtils.isNullOrEmpty(delimiter = root.getChildText("Delimiter"))) {
                multipartUploadListing.setDelimiter(delimiter);
            }
            if (root.getChild("Prefix") != null && !CodingUtils.isNullOrEmpty(prefix = root.getChildText("Prefix"))) {
                multipartUploadListing.setPrefix(prefix);
            }
            if (root.getChild("KeyMarker") != null && !CodingUtils.isNullOrEmpty(keyMarker = root.getChildText("KeyMarker"))) {
                multipartUploadListing.setKeyMarker(keyMarker);
            }
            if (root.getChild("UploadIdMarker") != null && !CodingUtils.isNullOrEmpty(uploadIdMarker = root.getChildText("UploadIdMarker"))) {
                multipartUploadListing.setUploadIdMarker(uploadIdMarker);
            }
            if (root.getChild("NextKeyMarker") != null && !CodingUtils.isNullOrEmpty(nextKeyMarker = root.getChildText("NextKeyMarker"))) {
                multipartUploadListing.setNextKeyMarker(nextKeyMarker);
            }
            if (root.getChild("NextUploadIdMarker") != null && !CodingUtils.isNullOrEmpty(nextUploadIdMarker = root.getChildText("NextUploadIdMarker"))) {
                multipartUploadListing.setNextUploadIdMarker(nextUploadIdMarker);
            }
            List uploadElems = root.getChildren("Upload");
            for (Element elem : uploadElems) {
                if (elem.getChild("Initiated") == null) continue;
                MultipartUpload mu = new MultipartUpload();
                mu.setKey(elem.getChildText("Key"));
                mu.setUploadId(elem.getChildText("UploadId"));
                mu.setStorageClass(elem.getChildText("StorageClass"));
                mu.setInitiated(DateUtil.parseIso8601Date(elem.getChildText("Initiated")));
                multipartUploadListing.addMultipartUpload(mu);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix2 = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix2)) continue;
                multipartUploadListing.addCommonPrefix(prefix2);
            }
            return multipartUploadListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static PartListing parseListParts(InputStream responseBody) throws ResponseParseException {
        try {
            String nextPartNumberMarker;
            String partNumberMarker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            PartListing partListing = new PartListing();
            partListing.setBucketName(root.getChildText("Bucket"));
            partListing.setKey(root.getChildText("Key"));
            partListing.setUploadId(root.getChildText("UploadId"));
            partListing.setStorageClass(root.getChildText("StorageClass"));
            partListing.setMaxParts(Integer.valueOf(root.getChildText("MaxParts")));
            partListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("PartNumberMarker") != null && !CodingUtils.isNullOrEmpty(partNumberMarker = root.getChildText("PartNumberMarker"))) {
                partListing.setPartNumberMarker(Integer.valueOf(partNumberMarker));
            }
            if (root.getChild("NextPartNumberMarker") != null && !CodingUtils.isNullOrEmpty(nextPartNumberMarker = root.getChildText("NextPartNumberMarker"))) {
                partListing.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
            }
            List partElems = root.getChildren("Part");
            for (Element elem : partElems) {
                PartSummary ps = new PartSummary();
                ps.setPartNumber(Integer.valueOf(elem.getChildText("PartNumber")));
                ps.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ps.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ps.setSize(Integer.valueOf(elem.getChildText("Size")).intValue());
                partListing.addPart(ps);
            }
            return partListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CompleteMultipartUploadResult parseCompleteMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setBucketName(root.getChildText("Bucket"));
            result.setETag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            result.setKey(root.getChildText("Key"));
            result.setLocation(root.getChildText("Location"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketLoggingResult parseBucketLogging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketLoggingResult result = new BucketLoggingResult();
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetBucket(root.getChild("LoggingEnabled").getChildText("TargetBucket"));
            }
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetPrefix(root.getChild("LoggingEnabled").getChildText("TargetPrefix"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketImageResult parseBucketImage(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketImageResult result = new GetBucketImageResult();
            result.SetBucketName(root.getChildText("Name"));
            result.SetDefault404Pic(root.getChildText("Default404Pic"));
            result.SetStyleDelimiters(root.getChildText("StyleDelimiters"));
            result.SetStatus(root.getChildText("Status"));
            result.SetIsAutoSetContentType(root.getChildText("AutoSetContentType").equals("True"));
            result.SetIsForbidOrigPicAccess(root.getChildText("OrigPicForbidden").equals("True"));
            result.SetIsSetAttachName(root.getChildText("SetAttachName").equals("True"));
            result.SetIsUseStyleOnly(root.getChildText("UseStyleOnly").equals("True"));
            result.SetIsUseSrcFormat(root.getChildText("UseSrcFormat").equals("True"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetImageStyleResult parseImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetImageStyleResult result = new GetImageStyleResult();
            result.SetStyleName(root.getChildText("Name"));
            result.SetStyle(root.getChildText("Content"));
            result.SetLastModifyTime(DateUtil.parseRfc822Date(root.getChildText("LastModifyTime")));
            result.SetCreationDate(DateUtil.parseRfc822Date(root.getChildText("CreateTime")));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketProcess parseGetBucketImageProcessConf(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String compliedHost = root.getChildText("CompliedHost");
            boolean sourceFileProtect = false;
            if (root.getChildText("SourceFileProtect").equals("Enabled")) {
                sourceFileProtect = true;
            }
            String sourceFileProtectSuffix = root.getChildText("SourceFileProtectSuffix");
            String styleDelimiters = root.getChildText("StyleDelimiters");
            ImageProcess imageProcess = new ImageProcess(compliedHost, sourceFileProtect, sourceFileProtectSuffix, styleDelimiters);
            if (root.getChildText("Version") != null) {
                imageProcess.setVersion(Integer.parseInt(root.getChildText("Version")));
            }
            return new BucketProcess(imageProcess);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketWebsiteResult parseBucketWebsite(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketWebsiteResult result = new BucketWebsiteResult();
            if (root.getChild("IndexDocument") != null) {
                result.setIndexDocument(root.getChild("IndexDocument").getChildText("Suffix"));
            }
            if (root.getChild("ErrorDocument") != null) {
                result.setErrorDocument(root.getChild("ErrorDocument").getChildText("Key"));
            }
            if (root.getChild("RoutingRules") != null) {
                List ruleElements = root.getChild("RoutingRules").getChildren("RoutingRule");
                for (Element ruleElem : ruleElements) {
                    Element redirectElem;
                    RoutingRule rule = new RoutingRule();
                    rule.setNumber(Integer.parseInt(ruleElem.getChildText("RuleNumber")));
                    Element condElem = ruleElem.getChild("Condition");
                    if (condElem != null) {
                        rule.getCondition().setKeyPrefixEquals(condElem.getChildText("KeyPrefixEquals"));
                        if (condElem.getChild("HttpErrorCodeReturnedEquals") != null) {
                            rule.getCondition().setHttpErrorCodeReturnedEquals(Integer.parseInt(condElem.getChildText("HttpErrorCodeReturnedEquals")));
                        }
                    }
                    if ((redirectElem = ruleElem.getChild("Redirect")).getChild("RedirectType") != null) {
                        rule.getRedirect().setRedirectType(RoutingRule.RedirectType.parse(redirectElem.getChildText("RedirectType")));
                    }
                    rule.getRedirect().setHostName(redirectElem.getChildText("HostName"));
                    if (redirectElem.getChild("Protocol") != null) {
                        rule.getRedirect().setProtocol(RoutingRule.Protocol.parse(redirectElem.getChildText("Protocol")));
                    }
                    rule.getRedirect().setReplaceKeyPrefixWith(redirectElem.getChildText("ReplaceKeyPrefixWith"));
                    rule.getRedirect().setReplaceKeyWith(redirectElem.getChildText("ReplaceKeyWith"));
                    if (redirectElem.getChild("HttpRedirectCode") != null) {
                        rule.getRedirect().setHttpRedirectCode(Integer.parseInt(redirectElem.getChildText("HttpRedirectCode")));
                    }
                    rule.getRedirect().setMirrorURL(redirectElem.getChildText("MirrorURL"));
                    rule.getRedirect().setMirrorSecondaryURL(redirectElem.getChildText("MirrorURLSlave"));
                    rule.getRedirect().setMirrorProbeURL(redirectElem.getChildText("MirrorURLProbe"));
                    if (redirectElem.getChildText("MirrorPassQueryString") != null) {
                        rule.getRedirect().setPassQueryString(Boolean.valueOf(redirectElem.getChildText("MirrorPassQueryString")));
                    }
                    if (redirectElem.getChildText("MirrorPassOriginalSlashes") != null) {
                        rule.getRedirect().setPassOriginalSlashes(Boolean.valueOf(redirectElem.getChildText("MirrorPassOriginalSlashes")));
                    }
                    result.AddRoutingRule(rule);
                }
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CopyObjectResult parseCopyObjectResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CopyObjectResult result = new CopyObjectResult();
            result.setLastModified(DateUtil.parseIso8601Date(root.getChildText("LastModified")));
            result.setEtag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteObjectsResult parseDeleteObjectsResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            DeleteObjectsResult deleteObjectsResult = new DeleteObjectsResult();
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                deleteObjectsResult.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            ArrayList<String> deletedObjects = new ArrayList<String>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                deletedObjects.add(elem.getChildText("Key"));
            }
            deleteObjectsResult.setDeletedObjects(deletedObjects);
            return deleteObjectsResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteVersionsResult parseDeleteVersionsResult(InputStream responseBody) throws ResponseParseException {
        boolean shouldSDKDecodeResponse = false;
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                shouldSDKDecodeResponse = "url".equals(encodingType);
            }
            ArrayList<DeleteVersionsResult.DeletedVersion> deletedVersions = new ArrayList<DeleteVersionsResult.DeletedVersion>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                DeleteVersionsResult.DeletedVersion key = new DeleteVersionsResult.DeletedVersion();
                if (shouldSDKDecodeResponse) {
                    key.setKey(HttpUtil.urlDecode(elem.getChildText("Key"), "UTF-8"));
                } else {
                    key.setKey(elem.getChildText("Key"));
                }
                if (elem.getChild("VersionId") != null) {
                    key.setVersionId(elem.getChildText("VersionId"));
                }
                if (elem.getChild("DeleteMarker") != null) {
                    key.setDeleteMarker(Boolean.parseBoolean(elem.getChildText("DeleteMarker")));
                }
                if (elem.getChild("DeleteMarkerVersionId") != null) {
                    key.setDeleteMarkerVersionId(elem.getChildText("DeleteMarkerVersionId"));
                }
                deletedVersions.add(key);
            }
            return new DeleteVersionsResult(deletedVersions);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<SetBucketCORSRequest.CORSRule> parseListBucketCORS(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<SetBucketCORSRequest.CORSRule> corsRules = new ArrayList<SetBucketCORSRequest.CORSRule>();
            List corsRuleElems = root.getChildren("CORSRule");
            for (Element corsRuleElem : corsRuleElems) {
                SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
                List allowedOriginElems = corsRuleElem.getChildren("AllowedOrigin");
                for (Element allowedOriginElement : allowedOriginElems) {
                    rule.getAllowedOrigins().add(allowedOriginElement.getValue());
                }
                List allowedMethodElems = corsRuleElem.getChildren("AllowedMethod");
                for (Element allowedMethodElement : allowedMethodElems) {
                    rule.getAllowedMethods().add(allowedMethodElement.getValue());
                }
                List allowedHeaderElems = corsRuleElem.getChildren("AllowedHeader");
                for (Element allowedHeaderElement : allowedHeaderElems) {
                    rule.getAllowedHeaders().add(allowedHeaderElement.getValue());
                }
                List exposeHeaderElems = corsRuleElem.getChildren("ExposeHeader");
                for (Element exposeHeaderElement : exposeHeaderElems) {
                    rule.getExposeHeaders().add(exposeHeaderElement.getValue());
                }
                Element maxAgeSecondsElem = corsRuleElem.getChild("MaxAgeSeconds");
                if (maxAgeSecondsElem != null) {
                    rule.setMaxAgeSeconds(Integer.parseInt(maxAgeSecondsElem.getValue()));
                }
                corsRules.add(rule);
            }
            return corsRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static TagSet parseGetBucketTagging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            TagSet tagSet = new TagSet();
            List tagElems = root.getChild("TagSet").getChildren("Tag");
            for (Element tagElem : tagElems) {
                String key = null;
                String value = null;
                if (tagElem.getChild("Key") != null) {
                    key = tagElem.getChildText("Key");
                }
                if (tagElem.getChild("Value") != null) {
                    value = tagElem.getChildText("Value");
                }
                tagSet.setTag(key, value);
            }
            return tagSet;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<ReplicationRule> parseGetBucketReplication(InputStream responseBody) throws ResponseParseException {
        try {
            ArrayList<ReplicationRule> repRules = new ArrayList<ReplicationRule>();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            List ruleElems = root.getChildren("Rule");
            for (Element ruleElem : ruleElems) {
                ReplicationRule repRule = new ReplicationRule();
                repRule.setReplicationRuleID(ruleElem.getChildText("ID"));
                Element destination = ruleElem.getChild("Destination");
                repRule.setTargetBucketName(destination.getChildText("Bucket"));
                repRule.setTargetBucketLocation(destination.getChildText("Location"));
                repRule.setTargetCloud(destination.getChildText("Cloud"));
                repRule.setTargetCloudLocation(destination.getChildText("CloudLocation"));
                repRule.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
                if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                    repRule.setEnableHistoricalObjectReplication(true);
                } else {
                    repRule.setEnableHistoricalObjectReplication(false);
                }
                if (ruleElem.getChild("PrefixSet") != null) {
                    ArrayList<String> objectPrefixes = new ArrayList<String>();
                    List prefixElems = ruleElem.getChild("PrefixSet").getChildren("Prefix");
                    for (Element prefixElem : prefixElems) {
                        objectPrefixes.add(prefixElem.getText());
                    }
                    repRule.setObjectPrefixList(objectPrefixes);
                }
                if (ruleElem.getChild("Action") != null) {
                    String[] actionStrs = ruleElem.getChildText("Action").split(",");
                    ArrayList<AddBucketReplicationRequest.ReplicationAction> repActions = new ArrayList<AddBucketReplicationRequest.ReplicationAction>();
                    for (String actionStr : actionStrs) {
                        repActions.add(AddBucketReplicationRequest.ReplicationAction.parse(actionStr));
                    }
                    repRule.setReplicationActionList(repActions);
                }
                repRule.setSyncRole(ruleElem.getChildText("SyncRole"));
                if (ruleElem.getChild("EncryptionConfiguration") != null) {
                    repRule.setReplicaKmsKeyID(ruleElem.getChild("EncryptionConfiguration").getChildText("ReplicaKmsKeyID"));
                }
                if (ruleElem.getChild("SourceSelectionCriteria") != null && ruleElem.getChild("SourceSelectionCriteria").getChildren("SseKmsEncryptedObjects") != null) {
                    repRule.setSseKmsEncryptedObjectsStatus(ruleElem.getChild("SourceSelectionCriteria").getChild("SseKmsEncryptedObjects").getChildText("Status"));
                }
                repRules.add(repRule);
            }
            return repRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReplicationProgress parseGetBucketReplicationProgress(InputStream responseBody) throws ResponseParseException {
        try {
            BucketReplicationProgress progress = new BucketReplicationProgress();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element ruleElem = root.getChild("Rule");
            progress.setReplicationRuleID(ruleElem.getChildText("ID"));
            Element destination = ruleElem.getChild("Destination");
            progress.setTargetBucketName(destination.getChildText("Bucket"));
            progress.setTargetBucketLocation(destination.getChildText("Location"));
            progress.setTargetCloud(destination.getChildText("Cloud"));
            progress.setTargetCloudLocation(destination.getChildText("CloudLocation"));
            progress.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
            if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                progress.setEnableHistoricalObjectReplication(true);
            } else {
                progress.setEnableHistoricalObjectReplication(false);
            }
            Element progressElem = ruleElem.getChild("Progress");
            if (progressElem != null) {
                if (progressElem.getChild("HistoricalObject") != null) {
                    progress.setHistoricalObjectProgress(Float.parseFloat(progressElem.getChildText("HistoricalObject")));
                }
                progress.setNewObjectProgress(DateUtil.parseIso8601Date(progressElem.getChildText("NewObject")));
            }
            return progress;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<String> parseGetBucketReplicationLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<String> locationList = new ArrayList<String>();
            List locElements = root.getChildren("Location");
            for (Element locElem : locElements) {
                locationList.add(locElem.getText());
            }
            return locationList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketInfo parseGetBucketInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element bucketElem = root.getChild("Bucket");
            BucketInfo bucketInfo = new BucketInfo();
            Bucket bucket = new Bucket();
            String id = bucketElem.getChild("Owner").getChildText("ID");
            String displayName = bucketElem.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            bucket.setOwner(owner);
            bucket.setName(bucketElem.getChildText("Name"));
            bucket.setLocation(bucketElem.getChildText("Location"));
            bucket.setExtranetEndpoint(bucketElem.getChildText("ExtranetEndpoint"));
            bucket.setIntranetEndpoint(bucketElem.getChildText("IntranetEndpoint"));
            bucket.setCreationDate(DateUtil.parseIso8601Date(bucketElem.getChildText("CreationDate")));
            if (bucketElem.getChild("StorageClass") != null) {
                bucket.setStorageClass(StorageClass.parse(bucketElem.getChildText("StorageClass")));
            }
            bucketInfo.setBucket(bucket);
            String comment = bucketElem.getChildText("Comment");
            bucketInfo.setComment(comment);
            String dataRedundancyString = bucketElem.getChildText("DataRedundancyType");
            DataRedundancyType dataRedundancyType = DataRedundancyType.parse(dataRedundancyString);
            bucketInfo.setDataRedundancyType(dataRedundancyType);
            String aclString = bucketElem.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList acl = CannedAccessControlList.parse(aclString);
            bucketInfo.setCannedACL(acl);
            switch (acl) {
                case PublicRead: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            Element sseElem = bucketElem.getChild("ServerSideEncryptionRule");
            if (sseElem != null) {
                ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = new ServerSideEncryptionConfiguration();
                ServerSideEncryptionByDefault applyServerSideEncryptionByDefault = new ServerSideEncryptionByDefault();
                applyServerSideEncryptionByDefault.setSSEAlgorithm(sseElem.getChildText("SSEAlgorithm"));
                if (sseElem.getChild("KMSMasterKeyID") != null) {
                    applyServerSideEncryptionByDefault.setKMSMasterKeyID(sseElem.getChildText("KMSMasterKeyID"));
                }
                serverSideEncryptionConfiguration.setApplyServerSideEncryptionByDefault(applyServerSideEncryptionByDefault);
                bucketInfo.setServerSideEncryptionConfiguration(serverSideEncryptionConfiguration);
            }
            return bucketInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketStat parseGetBucketStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Long storage = Long.parseLong(root.getChildText("Storage"));
            Long objectCount = Long.parseLong(root.getChildText("ObjectCount"));
            Long multipartUploadCount = Long.parseLong(root.getChildText("MultipartUploadCount"));
            BucketStat bucketStat = new BucketStat(storage, objectCount, multipartUploadCount);
            return bucketStat;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CreateLiveChannelResult parseCreateLiveChannel(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CreateLiveChannelResult result = new CreateLiveChannelResult();
            ArrayList<String> publishUrls = new ArrayList<String>();
            List publishElems = root.getChild("PublishUrls").getChildren("Url");
            for (Element urlElem : publishElems) {
                publishUrls.add(urlElem.getText());
            }
            result.setPublishUrls(publishUrls);
            ArrayList<String> playUrls = new ArrayList<String>();
            List playElems = root.getChild("PlayUrls").getChildren("Url");
            for (Element urlElem : playElems) {
                playUrls.add(urlElem.getText());
            }
            result.setPlayUrls(playUrls);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelInfo parseGetLiveChannelInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelInfo result = new LiveChannelInfo();
            result.setDescription(root.getChildText("Description"));
            result.setStatus(LiveChannelStatus.parse(root.getChildText("Status")));
            Element targetElem = root.getChild("Target");
            LiveChannelTarget target = new LiveChannelTarget();
            target.setType(targetElem.getChildText("Type"));
            target.setFragDuration(Integer.parseInt(targetElem.getChildText("FragDuration")));
            target.setFragCount(Integer.parseInt(targetElem.getChildText("FragCount")));
            target.setPlaylistName(targetElem.getChildText("PlaylistName"));
            result.setTarget(target);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelStat parseGetLiveChannelStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element audioElem;
            Element videoElem;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelStat result = new LiveChannelStat();
            result.setPushflowStatus(PushflowStatus.parse(root.getChildText("Status")));
            if (root.getChild("ConnectedTime") != null) {
                result.setConnectedDate(DateUtil.parseIso8601Date(root.getChildText("ConnectedTime")));
            }
            if (root.getChild("RemoteAddr") != null) {
                result.setRemoteAddress(root.getChildText("RemoteAddr"));
            }
            if ((videoElem = root.getChild("Video")) != null) {
                LiveChannelStat.VideoStat videoStat = new LiveChannelStat.VideoStat();
                videoStat.setWidth(Integer.parseInt(videoElem.getChildText("Width")));
                videoStat.setHeight(Integer.parseInt(videoElem.getChildText("Height")));
                videoStat.setFrameRate(Integer.parseInt(videoElem.getChildText("FrameRate")));
                videoStat.setBandWidth(Integer.parseInt(videoElem.getChildText("Bandwidth")));
                videoStat.setCodec(videoElem.getChildText("Codec"));
                result.setVideoStat(videoStat);
            }
            if ((audioElem = root.getChild("Audio")) != null) {
                LiveChannelStat.AudioStat audioStat = new LiveChannelStat.AudioStat();
                audioStat.setBandWidth(Integer.parseInt(audioElem.getChildText("Bandwidth")));
                audioStat.setSampleRate(Integer.parseInt(audioElem.getChildText("SampleRate")));
                audioStat.setCodec(audioElem.getChildText("Codec"));
                result.setAudioStat(audioStat);
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LiveRecord> parseGetLiveChannelHistory(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LiveRecord> liveRecords = new ArrayList<LiveRecord>();
            List recordElements = root.getChildren("LiveRecord");
            for (Element recordElem : recordElements) {
                LiveRecord record = new LiveRecord();
                record.setStartDate(DateUtil.parseIso8601Date(recordElem.getChildText("StartTime")));
                record.setEndDate(DateUtil.parseIso8601Date(recordElem.getChildText("EndTime")));
                record.setRemoteAddress(recordElem.getChildText("RemoteAddr"));
                liveRecords.add(record);
            }
            return liveRecords;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelListing parseListLiveChannels(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelListing liveChannelListing = new LiveChannelListing();
            liveChannelListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                liveChannelListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                liveChannelListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("MaxKeys") != null) {
                String maxKeys = root.getChildText("MaxKeys");
                liveChannelListing.setMaxKeys(Integer.valueOf(maxKeys));
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                liveChannelListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List liveChannelElems = root.getChildren("LiveChannel");
            for (Element elem : liveChannelElems) {
                LiveChannel liveChannel = new LiveChannel();
                liveChannel.setName(elem.getChildText("Name"));
                liveChannel.setDescription(elem.getChildText("Description"));
                liveChannel.setStatus(LiveChannelStatus.parse(elem.getChildText("Status")));
                liveChannel.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ArrayList<String> publishUrls = new ArrayList<String>();
                List publishElems = elem.getChild("PublishUrls").getChildren("Url");
                for (Element urlElem : publishElems) {
                    publishUrls.add(urlElem.getText());
                }
                liveChannel.setPublishUrls(publishUrls);
                ArrayList<String> playUrls = new ArrayList<String>();
                List playElems = elem.getChild("PlayUrls").getChildren("Url");
                for (Element urlElem : playElems) {
                    playUrls.add(urlElem.getText());
                }
                liveChannel.setPlayUrls(playUrls);
                liveChannelListing.addLiveChannel(liveChannel);
            }
            return liveChannelListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UserQos parseGetUserQos(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            UserQos userQos = new UserQos();
            if (root.getChild("StorageCapacity") != null) {
                userQos.setStorageCapacity(Integer.parseInt(root.getChildText("StorageCapacity")));
            }
            return userQos;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketVersioningConfiguration parseGetBucketVersioning(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();
            configuration.setStatus(root.getChildText("Status"));
            return configuration;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ServerSideEncryptionConfiguration parseGetBucketEncryption(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ServerSideEncryptionConfiguration configuration = new ServerSideEncryptionConfiguration();
            ServerSideEncryptionByDefault sseByDefault = new ServerSideEncryptionByDefault();
            Element sseElem = root.getChild("ApplyServerSideEncryptionByDefault");
            sseByDefault.setSSEAlgorithm(sseElem.getChildText("SSEAlgorithm"));
            sseByDefault.setKMSMasterKeyID(sseElem.getChildText("KMSMasterKeyID"));
            configuration.setApplyServerSideEncryptionByDefault(sseByDefault);
            return configuration;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketPolicyResult parseGetBucketPolicy(InputStream responseBody) throws ResponseParseException {
        try {
            String s;
            GetBucketPolicyResult result = new GetBucketPolicyResult();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
            StringBuilder sb = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            result.setPolicy(sb.toString());
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketRequestPaymentResult parseGetBucketRequestPayment(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketRequestPaymentResult paymentResult = new GetBucketRequestPaymentResult();
            if (root.getChild("Payer") != null) {
                Payer payer = Payer.parse(root.getChildText("Payer"));
                paymentResult.setPayer(payer);
            }
            return paymentResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UserQosInfo parseGetUserQosInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            UserQosInfo userQosInfo = new UserQosInfo();
            userQosInfo.setRegion(root.getChildText("Region"));
            userQosInfo.setTotalUploadBw(Integer.valueOf(root.getChildText("TotalUploadBandwidth")));
            userQosInfo.setIntranetUploadBw(Integer.valueOf(root.getChildText("IntranetUploadBandwidth")));
            userQosInfo.setExtranetUploadBw(Integer.valueOf(root.getChildText("ExtranetUploadBandwidth")));
            userQosInfo.setTotalDownloadBw(Integer.valueOf(root.getChildText("TotalDownloadBandwidth")));
            userQosInfo.setIntranetDownloadBw(Integer.valueOf(root.getChildText("IntranetDownloadBandwidth")));
            userQosInfo.setExtranetDownloadBw(Integer.valueOf(root.getChildText("ExtranetDownloadBandwidth")));
            userQosInfo.setTotalQps(Integer.valueOf(root.getChildText("TotalQps")));
            userQosInfo.setIntranetQps(Integer.valueOf(root.getChildText("IntranetQps")));
            userQosInfo.setExtranetQps(Integer.valueOf(root.getChildText("ExtranetQps")));
            return userQosInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketQosInfo parseGetBucketQosInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketQosInfo bucketQosInfo = new BucketQosInfo();
            bucketQosInfo.setTotalUploadBw(Integer.valueOf(root.getChildText("TotalUploadBandwidth")));
            bucketQosInfo.setIntranetUploadBw(Integer.valueOf(root.getChildText("IntranetUploadBandwidth")));
            bucketQosInfo.setExtranetUploadBw(Integer.valueOf(root.getChildText("ExtranetUploadBandwidth")));
            bucketQosInfo.setTotalDownloadBw(Integer.valueOf(root.getChildText("TotalDownloadBandwidth")));
            bucketQosInfo.setIntranetDownloadBw(Integer.valueOf(root.getChildText("IntranetDownloadBandwidth")));
            bucketQosInfo.setExtranetDownloadBw(Integer.valueOf(root.getChildText("ExtranetDownloadBandwidth")));
            bucketQosInfo.setTotalQps(Integer.valueOf(root.getChildText("TotalQps")));
            bucketQosInfo.setIntranetQps(Integer.valueOf(root.getChildText("IntranetQps")));
            bucketQosInfo.setExtranetQps(Integer.valueOf(root.getChildText("ExtranetQps")));
            return bucketQosInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LifecycleRule> parseGetBucketLifecycle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();
            List ruleElements = root.getChildren("Rule");
            for (Element ruleElem : ruleElements) {
                List tagElems;
                LifecycleRule rule = new LifecycleRule();
                if (ruleElem.getChild("ID") != null) {
                    rule.setId(ruleElem.getChildText("ID"));
                }
                if (ruleElem.getChild("Prefix") != null) {
                    rule.setPrefix(ruleElem.getChildText("Prefix"));
                }
                if ((tagElems = ruleElem.getChildren("Tag")) != null) {
                    for (Element tagElem : tagElems) {
                        String key = null;
                        String value = null;
                        if (tagElem.getChild("Key") != null) {
                            key = tagElem.getChildText("Key");
                        }
                        if (tagElem.getChild("Value") != null) {
                            value = tagElem.getChildText("Value");
                        }
                        rule.addTag(key, value);
                    }
                }
                if (ruleElem.getChild("Status") != null) {
                    rule.setStatus(LifecycleRule.RuleStatus.valueOf(ruleElem.getChildText("Status")));
                }
                if (ruleElem.getChild("Expiration") != null) {
                    if (ruleElem.getChild("Expiration").getChild("Date") != null) {
                        Date expirationDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("Date"));
                        rule.setExpirationTime(expirationDate);
                    } else if (ruleElem.getChild("Expiration").getChild("Days") != null) {
                        rule.setExpirationDays(Integer.parseInt(ruleElem.getChild("Expiration").getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("CreatedBeforeDate"));
                        rule.setCreatedBeforeDate(createdBeforeDate);
                    }
                }
                if (ruleElem.getChild("AbortMultipartUpload") != null) {
                    LifecycleRule.AbortMultipartUpload abortMultipartUpload = new LifecycleRule.AbortMultipartUpload();
                    if (ruleElem.getChild("AbortMultipartUpload").getChild("Days") != null) {
                        abortMultipartUpload.setExpirationDays(Integer.parseInt(ruleElem.getChild("AbortMultipartUpload").getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("AbortMultipartUpload").getChildText("CreatedBeforeDate"));
                        abortMultipartUpload.setCreatedBeforeDate(createdBeforeDate);
                    }
                    rule.setAbortMultipartUpload(abortMultipartUpload);
                }
                List transitionElements = ruleElem.getChildren("Transition");
                ArrayList<LifecycleRule.StorageTransition> storageTransitions = new ArrayList<LifecycleRule.StorageTransition>();
                for (Element transitionElem : transitionElements) {
                    LifecycleRule.StorageTransition storageTransition = new LifecycleRule.StorageTransition();
                    if (transitionElem.getChild("Days") != null) {
                        storageTransition.setExpirationDays(Integer.parseInt(transitionElem.getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(transitionElem.getChildText("CreatedBeforeDate"));
                        storageTransition.setCreatedBeforeDate(createdBeforeDate);
                    }
                    if (transitionElem.getChild("StorageClass") != null) {
                        storageTransition.setStorageClass(StorageClass.parse(transitionElem.getChildText("StorageClass")));
                    }
                    storageTransitions.add(storageTransition);
                }
                rule.setStorageTransition(storageTransitions);
                lifecycleRules.add(rule);
            }
            return lifecycleRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<CnameConfiguration> parseGetBucketCname(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<CnameConfiguration> cnames = new ArrayList<CnameConfiguration>();
            List cnameElements = root.getChildren("Cname");
            for (Element cnameElem : cnameElements) {
                CnameConfiguration cname = new CnameConfiguration();
                cname.setDomain(cnameElem.getChildText("Domain"));
                cname.setStatus(CnameConfiguration.CnameStatus.valueOf(cnameElem.getChildText("Status")));
                cname.setLastMofiedTime(DateUtil.parseIso8601Date(cnameElem.getChildText("LastModified")));
                if (cnameElem.getChildText("IsPurgeCdnCache") != null) {
                    boolean purgeCdnCache = Boolean.valueOf(cnameElem.getChildText("IsPurgeCdnCache"));
                    cname.setPurgeCdnCache(purgeCdnCache);
                }
                cnames.add(cname);
            }
            return cnames;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static final class GetSymbolicLinkResponseParser
    implements ResponseParser<OSSSymlink> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OSSSymlink parse(ResponseMessage response) throws ResponseParseException {
            try {
                OSSSymlink result = ResponseParsers.parseSymbolicLink(response);
                result.setRequestId(response.getRequestId());
                OSSSymlink oSSSymlink = result;
                return oSSSymlink;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class UploadPartCopyResponseParser
    implements ResponseParser<UploadPartCopyResult> {
        private int partNumber;

        public UploadPartCopyResponseParser(int partNumber) {
            this.partNumber = partNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UploadPartCopyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                UploadPartCopyResult result = new UploadPartCopyResult();
                result.setPartNumber(this.partNumber);
                result.setETag(OSSUtils.trimQuotes(ResponseParsers.parseUploadPartCopy(response.getContent())));
                result.setRequestId(response.getRequestId());
                UploadPartCopyResult uploadPartCopyResult = result;
                return uploadPartCopyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListPartsResponseParser
    implements ResponseParser<PartListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                PartListing result = ResponseParsers.parseListParts(response.getContent());
                result.setRequestId(response.getRequestId());
                PartListing partListing = result;
                return partListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListMultipartUploadsResponseParser
    implements ResponseParser<MultipartUploadListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MultipartUploadListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                MultipartUploadListing result = ResponseParsers.parseListMultipartUploads(response.getContent());
                result.setRequestId(response.getRequestId());
                MultipartUploadListing multipartUploadListing = result;
                return multipartUploadListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class InitiateMultipartUploadResponseParser
    implements ResponseParser<InitiateMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitiateMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                InitiateMultipartUploadResult result = ResponseParsers.parseInitiateMultipartUpload(response.getContent());
                result.setRequestId(response.getRequestId());
                InitiateMultipartUploadResult initiateMultipartUploadResult = result;
                return initiateMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CompleteMultipartUploadProcessResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setVersionId(response.getHeaders().get("x-oss-version-id"));
            result.setRequestId(response.getRequestId());
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CompleteMultipartUploadResult result = ResponseParsers.parseCompleteMultipartUpload(response.getContent());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                ResponseParsers.setServerCRC(result, response);
                CompleteMultipartUploadResult completeMultipartUploadResult = result;
                return completeMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteVersionsResponseParser
    implements ResponseParser<DeleteVersionsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteVersionsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteVersionsResult result = null;
                result = response.getContentLength() == 0L ? new DeleteVersionsResult(null) : ResponseParsers.parseDeleteVersionsResult(response.getContent());
                result.setRequestId(response.getRequestId());
                DeleteVersionsResult deleteVersionsResult = result;
                return deleteVersionsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteObjectsResponseParser
    implements ResponseParser<DeleteObjectsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteObjectsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteObjectsResult result = null;
                result = response.getContentLength() == 0L ? new DeleteObjectsResult(null) : ResponseParsers.parseDeleteObjectsResult(response.getContent());
                result.setRequestId(response.getRequestId());
                DeleteObjectsResult deleteObjectsResult = result;
                return deleteObjectsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyObjectResponseParser
    implements ResponseParser<CopyObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CopyObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CopyObjectResult result = ResponseParsers.parseCopyObjectResult(response.getContent());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                CopyObjectResult copyObjectResult = result;
                return copyObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class HeadObjectResponseParser
    implements ResponseParser<ObjectMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectMetadataResponseParser
    implements ResponseParser<ObjectMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ProcessObjectResponseParser
    implements ResponseParser<GenericResult> {
        @Override
        public GenericResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setResponse(response);
            return result;
        }
    }

    public static final class RestoreObjectResponseParser
    implements ResponseParser<RestoreObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RestoreObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                RestoreObjectResult result = new RestoreObjectResult(response.getStatusCode());
                result.setRequestId(response.getRequestId());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                RestoreObjectResult restoreObjectResult = result;
                return restoreObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetSimplifiedObjectMetaResponseParser
    implements ResponseParser<SimplifiedObjectMeta> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimplifiedObjectMeta parse(ResponseMessage response) throws ResponseParseException {
            try {
                SimplifiedObjectMeta simplifiedObjectMeta = ResponseParsers.parseSimplifiedObjectMeta(response.getHeaders());
                return simplifiedObjectMeta;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class GetObjectAclResponseParser
    implements ResponseParser<ObjectAcl> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectAcl parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectAcl result = ResponseParsers.parseGetObjectAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                ObjectAcl objectAcl = result;
                return objectAcl;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectResponseParser
    implements ResponseParser<OSSObject> {
        private String bucketName;
        private String key;

        public GetObjectResponseParser(String bucketName, String key) {
            this.bucketName = bucketName;
            this.key = key;
        }

        @Override
        public OSSObject parse(ResponseMessage response) throws ResponseParseException {
            OSSObject ossObject = new OSSObject();
            ossObject.setBucketName(this.bucketName);
            ossObject.setKey(this.key);
            ossObject.setObjectContent(response.getContent());
            ossObject.setRequestId(response.getRequestId());
            ossObject.setResponse(response);
            try {
                ossObject.setObjectMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
                ResponseParsers.setServerCRC(ossObject, response);
                return ossObject;
            }
            catch (ResponseParseException e) {
                OSSUtils.safeCloseResponse(response);
                throw e;
            }
        }
    }

    public static final class AppendObjectResponseParser
    implements ResponseParser<AppendObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppendObjectResult parse(ResponseMessage response) throws ResponseParseException {
            AppendObjectResult result = new AppendObjectResult();
            result.setRequestId(response.getRequestId());
            try {
                String nextPosition = response.getHeaders().get("x-oss-next-append-position");
                if (nextPosition != null) {
                    result.setNextPosition(Long.valueOf(nextPosition));
                }
                result.setObjectCRC(response.getHeaders().get("x-oss-hash-crc64ecma"));
                ResponseParsers.setCRC(result, response);
                AppendObjectResult appendObjectResult = result;
                return appendObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class PutObjectProcessReponseParser
    implements ResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
            result.setVersionId(response.getHeaders().get("x-oss-version-id"));
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class PutObjectReponseParser
    implements ResponseParser<PutObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            try {
                result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
                result.setVersionId(response.getHeaders().get("x-oss-version-id"));
                result.setRequestId(response.getRequestId());
                ResponseParsers.setCRC(result, response);
                PutObjectResult putObjectResult = result;
                return putObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListVersionsReponseParser
    implements ResponseParser<VersionListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VersionListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                VersionListing result = ResponseParsers.parseListVersions(response.getContent());
                result.setRequestId(response.getRequestId());
                VersionListing versionListing = result;
                return versionListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListObjectsReponseParser
    implements ResponseParser<ObjectListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectListing result = ResponseParsers.parseListObjects(response.getContent());
                result.setRequestId(response.getRequestId());
                ObjectListing objectListing = result;
                return objectListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationLocationResponseParser
    implements ResponseParser<List<String>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<String> list = ResponseParsers.parseGetBucketReplicationLocation(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationProgressResponseParser
    implements ResponseParser<BucketReplicationProgress> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReplicationProgress parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReplicationProgress result = ResponseParsers.parseGetBucketReplicationProgress(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReplicationProgress bucketReplicationProgress = result;
                return bucketReplicationProgress;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationResponseParser
    implements ResponseParser<List<ReplicationRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ReplicationRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<ReplicationRule> list = ResponseParsers.parseGetBucketReplication(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetTaggingResponseParser
    implements ResponseParser<TagSet> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TagSet parse(ResponseMessage response) throws ResponseParseException {
            try {
                TagSet result = ResponseParsers.parseGetBucketTagging(response.getContent());
                result.setRequestId(response.getRequestId());
                TagSet tagSet = result;
                return tagSet;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCorsResponseParser
    implements ResponseParser<List<SetBucketCORSRequest.CORSRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<SetBucketCORSRequest.CORSRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<SetBucketCORSRequest.CORSRule> list = ResponseParsers.parseListBucketCORS(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListLiveChannelsReponseParser
    implements ResponseParser<LiveChannelListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelListing liveChannelListing = ResponseParsers.parseListLiveChannels(response.getContent());
                return liveChannelListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelHistoryResponseParser
    implements ResponseParser<List<LiveRecord>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LiveRecord> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LiveRecord> list = ResponseParsers.parseGetLiveChannelHistory(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelStatResponseParser
    implements ResponseParser<LiveChannelStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelStat result = ResponseParsers.parseGetLiveChannelStat(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelStat liveChannelStat = result;
                return liveChannelStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelInfoResponseParser
    implements ResponseParser<LiveChannelInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelInfo result = ResponseParsers.parseGetLiveChannelInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelInfo liveChannelInfo = result;
                return liveChannelInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateLiveChannelResponseParser
    implements ResponseParser<CreateLiveChannelResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CreateLiveChannelResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateLiveChannelResult result = ResponseParsers.parseCreateLiveChannel(response.getContent());
                result.setRequestId(response.getRequestId());
                CreateLiveChannelResult createLiveChannelResult = result;
                return createLiveChannelResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketQosInfoResponseParser
    implements ResponseParser<BucketQosInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketQosInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketQosInfo result = ResponseParsers.parseGetBucketQosInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketQosInfo bucketQosInfo = result;
                return bucketQosInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUSerQosInfoResponseParser
    implements ResponseParser<UserQosInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserQosInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                UserQosInfo result = ResponseParsers.parseGetUserQosInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                UserQosInfo userQosInfo = result;
                return userQosInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRequestPaymentResponseParser
    implements ResponseParser<GetBucketRequestPaymentResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketRequestPaymentResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketRequestPaymentResult result = ResponseParsers.parseGetBucketRequestPayment(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketRequestPaymentResult getBucketRequestPaymentResult = result;
                return getBucketRequestPaymentResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketPolicyResponseParser
    implements ResponseParser<GetBucketPolicyResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketPolicyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketPolicyResult result = ResponseParsers.parseGetBucketPolicy(response.getContent());
                result.setRequestId(response.getRequestId());
                GetBucketPolicyResult getBucketPolicyResult = result;
                return getBucketPolicyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketEncryptionResponseParser
    implements ResponseParser<ServerSideEncryptionConfiguration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerSideEncryptionConfiguration parse(ResponseMessage response) throws ResponseParseException {
            try {
                ServerSideEncryptionConfiguration result;
                ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = result = ResponseParsers.parseGetBucketEncryption(response.getContent());
                return serverSideEncryptionConfiguration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketVersioningResponseParser
    implements ResponseParser<BucketVersioningConfiguration> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketVersioningConfiguration parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketVersioningConfiguration result;
                BucketVersioningConfiguration bucketVersioningConfiguration = result = ResponseParsers.parseGetBucketVersioning(response.getContent());
                return bucketVersioningConfiguration;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketQosResponseParser
    implements ResponseParser<UserQos> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserQos parse(ResponseMessage response) throws ResponseParseException {
            try {
                UserQos result = ResponseParsers.parseGetUserQos(response.getContent());
                result.setRequestId(response.getRequestId());
                UserQos userQos = result;
                return userQos;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketStatResponseParser
    implements ResponseParser<BucketStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketStat result = ResponseParsers.parseGetBucketStat(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketStat bucketStat = result;
                return bucketStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketInfoResponseParser
    implements ResponseParser<BucketInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketInfo result = ResponseParsers.parseGetBucketInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketInfo bucketInfo = result;
                return bucketInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCnameResponseParser
    implements ResponseParser<List<CnameConfiguration>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CnameConfiguration> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<CnameConfiguration> list = ResponseParsers.parseGetBucketCname(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLifecycleResponseParser
    implements ResponseParser<List<LifecycleRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LifecycleRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LifecycleRule> list = ResponseParsers.parseGetBucketLifecycle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketWebsiteResponseParser
    implements ResponseParser<BucketWebsiteResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketWebsiteResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketWebsiteResult result = ResponseParsers.parseBucketWebsite(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketWebsiteResult bucketWebsiteResult = result;
                return bucketWebsiteResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageProcessConfResponseParser
    implements ResponseParser<BucketProcess> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketProcess parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketProcess result = ResponseParsers.parseGetBucketImageProcessConf(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketProcess bucketProcess = result;
                return bucketProcess;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetImageStyleResponseParser
    implements ResponseParser<GetImageStyleResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetImageStyleResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetImageStyleResult getImageStyleResult = ResponseParsers.parseImageStyle(response.getContent());
                return getImageStyleResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageResponseParser
    implements ResponseParser<GetBucketImageResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketImageResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketImageResult getBucketImageResult = ResponseParsers.parseBucketImage(response.getContent());
                return getBucketImageResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLoggingResponseParser
    implements ResponseParser<BucketLoggingResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketLoggingResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketLoggingResult result = ResponseParsers.parseBucketLogging(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketLoggingResult bucketLoggingResult = result;
                return bucketLoggingResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLocationResponseParser
    implements ResponseParser<String> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                String string = ResponseParsers.parseGetBucketLocation(response.getContent());
                return string;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketMetadataResponseParser
    implements ResponseParser<BucketMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketMetadata bucketMetadata = ResponseParsers.parseBucketMetadata(response.getHeaders());
                return bucketMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketAclResponseParser
    implements ResponseParser<AccessControlList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessControlList parse(ResponseMessage response) throws ResponseParseException {
            try {
                AccessControlList result = ResponseParsers.parseGetBucketAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                AccessControlList accessControlList = result;
                return accessControlList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRefererResponseParser
    implements ResponseParser<BucketReferer> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReferer parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReferer result = ResponseParsers.parseGetBucketReferer(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReferer bucketReferer = result;
                return bucketReferer;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListImageStyleResponseParser
    implements ResponseParser<List<Style>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Style> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<Style> list = ResponseParsers.parseListImageStyle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListBucketResponseParser
    implements ResponseParser<BucketList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketList parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketList result = ResponseParsers.parseListBucket(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketList bucketList = result;
                return bucketList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            OSSUtils.safeCloseResponse(response);
            return response;
        }
    }
}

